/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.Node;

public abstract class SequentialNode
extends Node {
    private Node successor;

    public SequentialNode(ControlFlowGraph graph) {
        super(graph);
    }

    public Node getSuccessor() {
        return this.successor;
    }

    void setSuccessor(Node successor) {
        this.successor = successor;
    }

    public void insertAfter(SequentialNode newNode) {
        Node oldSuccessor = this.successor;
        this.successor = newNode;
        newNode.addPredecessor(this);
        if (oldSuccessor != null) {
            newNode.successor = oldSuccessor;
            oldSuccessor.removePredecessor(this);
            oldSuccessor.addPredecessor(newNode);
        }
    }

    @Override
    public void replaceSuccessor(Node oldSuccessor, Node newSuccessor) {
        if (this.successor == oldSuccessor) {
            this.successor = null;
            oldSuccessor.removePredecessor(this);
            newSuccessor.removePredecessor(oldSuccessor);
            newSuccessor.addPredecessor(this);
            this.successor = newSuccessor;
        }
    }

    public abstract SequentialNode copyElements();

    public SequentialNode copy() {
        SequentialNode copy = this.copyElements();
        copy.setSuccessor(this.successor);
        for (Node p : this.getPredecessors()) {
            copy.addPredecessor(p);
        }
        return copy;
    }
}

