/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.dfg.Variable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class VariableScope {
    public static final VariableScope GLOBAL = new VariableScope();
    private static int num;
    private String name;
    private Set<Variable> variables = new HashSet<Variable>();
    private VariableScope parent;

    private VariableScope() {
        this.parent = this;
        this.name = "GLOBAL";
    }

    public VariableScope(VariableScope parent) {
        this.parent = parent;
        this.name = Integer.toString(++num);
    }

    public void addVariable(Variable v) {
        this.variables.add(v);
    }

    public void removeVariable(Variable v) {
        this.variables.remove(v);
    }

    public VariableScope getParent() {
        return this.parent;
    }

    public Set<Variable> getDefinedVariables() {
        return this.variables;
    }

    public boolean containsDefinition(String name) {
        for (Variable v : this.variables) {
            if (!v.getName().equals(name)) continue;
            return true;
        }
        if (this != GLOBAL) {
            return this.parent.containsDefinition(name);
        }
        return false;
    }

    public String toString() {
        String result = this.name + "=";
        result = result + Arrays.toString(this.variables.toArray());
        return result;
    }
}

