/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import java.util.ArrayList;
import java.util.List;

public class MacroCall
extends Expression {
    private String name;
    private List<Expression> args;
    private boolean singleLine;
    private SequentialNode caller;

    public MacroCall(String name, List<Expression> args) {
        this.name = name;
        this.args = args;
    }

    public void setCaller(SequentialNode caller) {
        this.caller = caller;
    }

    public SequentialNode getCaller() {
        return this.caller;
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getArguments() {
        return this.args;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
    }

    public void setSingleLine() {
        this.singleLine = true;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression copy() {
        ArrayList<Expression> newArgs = new ArrayList<Expression>();
        for (Expression e : this.args) {
            newArgs.add(e.copy());
        }
        return new MacroCall(this.name, newArgs);
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        for (int i = 0; i < this.args.size(); ++i) {
            Expression arg = this.args.get(i);
            if (arg == old) {
                this.args.set(i, newExpression);
                continue;
            }
            arg.replaceExpression(old, newExpression);
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        int num = this.args.size();
        int i = 0;
        for (Expression e : this.args) {
            sb.append(e);
            if (i < num - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

