/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.Variable;

public final class MultivectorComponent
extends Variable {
    private int bladeIndex;

    public MultivectorComponent(String name, int bladeIndex) {
        super(name);
        this.bladeIndex = bladeIndex;
    }

    public int getBladeIndex() {
        return this.bladeIndex;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.bladeIndex + "]";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultivectorComponent that = (MultivectorComponent)o;
        return this.bladeIndex == that.bladeIndex;
    }

    @Override
    public MultivectorComponent copy() {
        return new MultivectorComponent(this.getName(), this.bladeIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.bladeIndex;
        return result;
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (old instanceof MultivectorComponent && newExpression instanceof MultivectorComponent) {
            MultivectorComponent oldVar = (MultivectorComponent)old;
            MultivectorComponent newVar = (MultivectorComponent)newExpression;
            if (oldVar.getName() == this.name && oldVar.getMinValue() == this.minValue && oldVar.getMaxValue() == this.maxValue && oldVar.getBladeIndex() == this.bladeIndex) {
                this.name = newVar.getName();
                this.minValue = newVar.getMinValue();
                this.maxValue = newVar.getMaxValue();
                this.bladeIndex = newVar.getBladeIndex();
            }
        } else if (old instanceof MultivectorComponent && newExpression instanceof Variable) {
            MultivectorComponent oldVar = (MultivectorComponent)old;
            Variable newVar = (Variable)newExpression;
            if (oldVar.getName() == this.name && oldVar.getMinValue() == this.minValue && oldVar.getMaxValue() == this.maxValue && oldVar.getBladeIndex() == this.bladeIndex) {
                this.name = newVar.getName();
                this.minValue = newVar.getMinValue();
                this.maxValue = newVar.getMaxValue();
                this.bladeIndex = 0;
            }
        } else {
            super.replaceExpression(old, newExpression);
        }
    }
}

