/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dfg;

import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;

public class Variable
extends Expression {
    protected String name;
    protected String minValue = null;
    protected String maxValue = null;
    private boolean global;

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public Variable(String name) {
        if (name.startsWith("::") && name.length() > 2) {
            this.global = true;
            this.name = name.substring(2);
        } else {
            this.name = name;
        }
    }

    public boolean globalAccess() {
        return this.global;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Variable copy() {
        Variable v = new Variable(this.name);
        v.global = this.global;
        v.setMaxValue(this.getMaxValue());
        v.setMinValue(this.getMinValue());
        return v;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (old instanceof Variable && newExpression instanceof Variable) {
            Variable oldVar = (Variable)old;
            Variable newVar = (Variable)newExpression;
            if (oldVar.getName() == this.name && oldVar.getMinValue() == this.minValue && oldVar.getMaxValue() == this.maxValue) {
                this.name = newVar.getName();
                this.minValue = newVar.getMinValue();
                this.maxValue = newVar.getMaxValue();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return this.name.equals(variable.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

