/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.visitor;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.gapp.ConstantSetVectorArgument;
import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.PosSelector;
import de.gaalop.gapp.PosSelectorset;
import de.gaalop.gapp.Selector;
import de.gaalop.gapp.Selectorset;
import de.gaalop.gapp.SetVectorArgument;
import de.gaalop.gapp.Valueset;
import de.gaalop.gapp.Variableset;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPSetOfVariables;
import de.gaalop.gapp.variables.GAPPValueHolder;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.gapp.visitor.CFGGAPPVisitor;
import java.util.LinkedList;
import java.util.ListIterator;

public class PrettyPrint
extends CFGGAPPVisitor {
    private StringBuilder result = new StringBuilder();

    @Override
    public void visit(AssignmentNode node) {
        this.result.append("//");
        this.result.append(node.getVariable().toString());
        this.result.append(" = ");
        this.result.append(node.getValue().toString());
        this.result.append('\n');
        if (node.getGAPP() != null) {
            node.getGAPP().accept(this, null);
        }
        this.result.append('\n');
        node.getSuccessor().accept(this);
    }

    public void clear() {
        this.result.setLength(0);
    }

    public String getResultString() {
        return this.result.toString();
    }

    private void printVector(GAPPVector vector) {
        this.result.append(vector.prettyPrint());
    }

    private void printMultivector(GAPPMultivector multiVector) {
        this.result.append(multiVector.prettyPrint());
    }

    private void printSetOfVariables(GAPPSetOfVariables setOfVariables) {
        this.result.append(setOfVariables.prettyPrint());
    }

    private void printSelector(Selector selector) {
        if (selector.getSign() == -1) {
            this.result.append('-');
        }
        this.result.append(selector.getIndex());
    }

    private void printSelectorIndex(PosSelector selectorIndex) {
        this.result.append(selectorIndex.getIndex());
    }

    private void printSelectors(Selectorset selectorset) {
        this.result.append("[");
        for (Selector cur : selectorset) {
            this.printSelector(cur);
            this.result.append(",");
        }
        this.result.deleteCharAt(this.result.length() - 1);
        this.result.append("]");
    }

    private void printPosSelectors(PosSelectorset posSelectorset) {
        this.result.append("[");
        for (PosSelector cur : posSelectorset) {
            this.printSelectorIndex(cur);
            this.result.append(",");
        }
        this.result.deleteCharAt(this.result.length() - 1);
        this.result.append("]");
    }

    private void printVariableSet(Variableset variableset) {
        this.result.append("[");
        for (GAPPValueHolder cur : variableset) {
            this.result.append(cur.prettyPrint());
            this.result.append(",");
        }
        this.result.deleteCharAt(this.result.length() - 1);
        this.result.append("]");
    }

    private void printValueSet(Valueset valueset) {
        this.result.append("[");
        for (GAPPValueHolder cur : valueset) {
            this.result.append(cur.prettyPrint());
            this.result.append(",");
        }
        this.result.deleteCharAt(this.result.length() - 1);
        this.result.append("]");
    }

    private void printArgument(SetVectorArgument arg) {
        if (arg.isConstant()) {
            this.result.append(((ConstantSetVectorArgument)arg).getValue());
        } else {
            PairSetOfVariablesAndIndices pair = (PairSetOfVariablesAndIndices)arg;
            this.result.append(pair.getSetOfVariable().prettyPrint());
            this.printSelectors(pair.getSelectors());
        }
    }

    private void printListOfArguments(LinkedList<SetVectorArgument> list) {
        this.result.append("{");
        for (SetVectorArgument cur : list) {
            this.printArgument(cur);
            this.result.append(",");
        }
        this.result.deleteCharAt(this.result.length() - 1);
        this.result.append("}");
    }

    private void printDotProduct(LinkedList<GAPPVector> vectors) {
        this.result.append("<");
        ListIterator it = vectors.listIterator();
        while (it.hasNext()) {
            this.printVector((GAPPVector)it.next());
            if (!it.hasNext()) continue;
            this.result.append(",");
        }
        this.result.append(">");
    }

    @Override
    public Object visitAssignMv(GAPPAssignMv gappAssignMv, Object arg) {
        this.result.append("assignMv ");
        this.printMultivector(gappAssignMv.getDestination());
        this.printPosSelectors(gappAssignMv.getSelectors());
        this.result.append(" = ");
        this.printValueSet(gappAssignMv.getValues());
        this.result.append(";\n");
        return null;
    }

    @Override
    public Object visitDotVectors(GAPPDotVectors gappDotVectors, Object arg) {
        this.result.append("dotVectors ");
        this.printMultivector(gappDotVectors.getDestination());
        this.result.append("[");
        this.printSelector(gappDotVectors.getDestSelector());
        this.result.append("]");
        this.result.append(" = ");
        this.printDotProduct(gappDotVectors.getParts());
        this.result.append(";\n");
        return null;
    }

    @Override
    public Object visitResetMv(GAPPResetMv gappResetMv, Object arg) {
        this.result.append("resetMv ");
        this.printMultivector(gappResetMv.getDestination());
        this.result.append("[");
        this.result.append(gappResetMv.getSize());
        this.result.append("];\n");
        return null;
    }

    @Override
    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        this.result.append("setMv ");
        this.printMultivector(gappSetMv.getDestination());
        this.printPosSelectors(gappSetMv.getSelectorsDest());
        this.result.append(" = ");
        this.printSetOfVariables(gappSetMv.getSource());
        this.printSelectors(gappSetMv.getSelectorsSrc());
        this.result.append(";\n");
        return null;
    }

    @Override
    public Object visitSetVector(GAPPSetVector gappSetVector, Object arg) {
        this.result.append("setVector ");
        this.printVector(gappSetVector.getDestination());
        this.result.append(" = ");
        this.printListOfArguments(gappSetVector.getEntries());
        this.result.append(";\n");
        return null;
    }

    @Override
    public Object visitCalculateMv(GAPPCalculateMv gappCalculateMv, Object arg) {
        this.result.append("calculateMv ");
        this.printMultivector(gappCalculateMv.getDestination());
        this.result.append(" = ");
        this.result.append(gappCalculateMv.getType().toString());
        this.result.append("(");
        this.printMultivector(gappCalculateMv.getOperand1());
        if (gappCalculateMv.getOperand2() != null) {
            this.result.append(",");
            this.printMultivector(gappCalculateMv.getOperand2());
        }
        this.result.append(");\n");
        return null;
    }

    @Override
    public Object visitAssignInputsVector(GAPPAssignInputsVector gappAssignInputsVector, Object arg) {
        this.result.append("assignInputsVector inputsVector = ");
        this.printVariableSet(gappAssignInputsVector.getValues());
        this.result.append(";\n");
        return null;
    }

    @Override
    public Object visitCalculateMvCoeff(GAPPCalculateMvCoeff gappCalculateMvCoeff, Object arg) {
        this.result.append("calculateMvCoeff ");
        this.result.append(gappCalculateMvCoeff.getDestination().getName());
        this.result.append("[");
        this.result.append(Integer.toString(gappCalculateMvCoeff.getDestination().getBladeIndex()));
        this.result.append("]");
        this.result.append(" = ");
        this.result.append(gappCalculateMvCoeff.getType().toString());
        this.result.append("(");
        this.printMultivector(gappCalculateMvCoeff.getOperand1());
        if (gappCalculateMvCoeff.getOperand2() != null) {
            this.result.append(",");
            this.printMultivector(gappCalculateMvCoeff.getOperand2());
        }
        this.result.append(");\n");
        return null;
    }
}

