/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cpp;

import de.gaalop.Notifications;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.cpp.OperatorPriority;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CppVisitor
implements ControlFlowVisitor,
ExpressionVisitor {
    protected Log log = LogFactory.getLog(CppVisitor.class);
    protected boolean standalone = true;
    protected final String suffix = "_opt";
    protected StringBuilder code = new StringBuilder();
    protected ControlFlowGraph graph;
    protected int indentation = 0;
    protected Set<String> assigned = new HashSet<String>();
    protected String variableType = "float";

    public CppVisitor(boolean standalone) {
        this.standalone = standalone;
    }

    public CppVisitor(boolean standalone, boolean useDouble) {
        this.standalone = standalone;
        if (useDouble) {
            this.variableType = "double";
        }
    }

    public CppVisitor(String variableType) {
        this.standalone = false;
        this.variableType = variableType;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public String getCode() {
        return this.code.toString();
    }

    protected void appendIndentation() {
        for (int i = 0; i < this.indentation; ++i) {
            this.code.append('\t');
        }
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        int bladeCount = this.graph.getAlgebraDefinitionFile().getBladeCount();
        List<Variable> localVariables = this.sortVariables(this.graph.getLocalVariables());
        if (this.standalone) {
            this.code.append("void calculate(");
            List<Variable> inputParameters = this.sortVariables(this.graph.getInputVariables());
            for (Variable var : inputParameters) {
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                this.code.append(", ");
            }
            for (Variable var : localVariables) {
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                this.code.append("[" + bladeCount + "], ");
            }
            if (this.graph.getLocalVariables().size() > 0) {
                this.code.setLength(this.code.length() - 2);
            }
            this.code.append(") {\n");
            ++this.indentation;
        } else {
            for (Variable var : localVariables) {
                this.appendIndentation();
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                this.code.append("[" + bladeCount + "] = { 0.0 };\n");
            }
        }
        if (this.graph.getScalarVariables().size() > 0) {
            this.appendIndentation();
            this.code.append(this.variableType).append(" ");
            for (Variable tmp : this.graph.getScalarVariables()) {
                this.code.append(tmp.getName());
                this.code.append(", ");
            }
            this.code.delete(this.code.length() - 2, this.code.length());
            this.code.append(";\n");
        }
        if (!this.graph.getLocalVariables().isEmpty()) {
            this.code.append("\n");
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected List<Variable> sortVariables(Set<Variable> inputVariables) {
        ArrayList<Variable> variables = new ArrayList<Variable>(inputVariables);
        Comparator<Variable> comparator = new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(variables, comparator);
        return variables;
    }

    public void visit(AssignmentNode node) {
        String variable = node.getVariable().getName();
        if (this.assigned.contains(variable)) {
            String message = "Variable " + variable + " has been reset for reuse.";
            this.log.warn((Object)message);
            Notifications.addWarning((String)message);
            this.code.append("\n");
            this.appendIndentation();
            this.code.append("memset(");
            this.code.append(variable);
            this.code.append(", 0, sizeof(");
            this.code.append(variable);
            this.code.append(")); // Reset variable for reuse.\n");
            this.assigned.remove(variable);
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";");
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.append(" // ");
            MultivectorComponent component = (MultivectorComponent)node.getVariable();
            this.code.append(node.getGraph().getAlgebraDefinitionFile().getBladeString(component.getBladeIndex()));
        }
        this.code.append('\n');
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndentation();
        node.getExpression().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.assigned.add(node.getValue().getName() + "_opt");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        Expression condition = node.getCondition();
        this.appendIndentation();
        this.code.append("if (");
        condition.accept((ExpressionVisitor)this);
        this.code.append(") {\n");
        ++this.indentation;
        node.getPositive().accept((ControlFlowVisitor)this);
        --this.indentation;
        this.appendIndentation();
        this.code.append("}");
        if (node.getNegative() instanceof BlockEndNode) {
            this.code.append("\n");
        } else {
            this.code.append(" else ");
            boolean isElseIf = false;
            if (node.getNegative() instanceof IfThenElseNode) {
                IfThenElseNode ifthenelse = (IfThenElseNode)node.getNegative();
                isElseIf = ifthenelse.isElseIf();
            }
            if (!isElseIf) {
                this.code.append("{\n");
                ++this.indentation;
            }
            node.getNegative().accept((ControlFlowVisitor)this);
            if (!isElseIf) {
                --this.indentation;
                this.appendIndentation();
                this.code.append("}\n");
            }
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(LoopNode node) {
        this.appendIndentation();
        this.code.append("while(true) {\n");
        ++this.indentation;
        node.getBody().accept((ControlFlowVisitor)this);
        --this.indentation;
        this.appendIndentation();
        this.code.append("}\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode breakNode) {
        this.appendIndentation();
        this.code.append("break;\n");
    }

    public void visit(BlockEndNode node) {
    }

    public void visit(EndNode node) {
        if (this.standalone) {
            --this.indentation;
            this.code.append("}\n");
        }
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected void addBinaryInfix(BinaryOperation op, String operator) {
        this.addChild((Expression)op, op.getLeft());
        this.code.append(operator);
        this.addChild((Expression)op, op.getRight());
    }

    protected void addChild(Expression parent, Expression child) {
        if (OperatorPriority.hasLowerPriority(parent, child)) {
            this.code.append('(');
            child.accept((ExpressionVisitor)this);
            this.code.append(')');
        } else {
            child.accept((ExpressionVisitor)this);
        }
    }

    public void visit(Subtraction subtraction) {
        this.addBinaryInfix((BinaryOperation)subtraction, " - ");
    }

    public void visit(Addition addition) {
        this.addBinaryInfix((BinaryOperation)addition, " + ");
    }

    public void visit(Division division) {
        this.addBinaryInfix((BinaryOperation)division, " / ");
    }

    public void visit(InnerProduct innerProduct) {
        throw new UnsupportedOperationException("The C/C++ backend does not support the inner product.");
    }

    public void visit(Multiplication multiplication) {
        this.addBinaryInfix((BinaryOperation)multiplication, " * ");
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        String funcName;
        switch (mathFunctionCall.getFunction()) {
            case ABS: {
                funcName = "fabs";
                break;
            }
            case SQRT: {
                funcName = "sqrtf";
                break;
            }
            default: {
                funcName = mathFunctionCall.getFunction().toString().toLowerCase();
            }
        }
        this.code.append(funcName);
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        this.code.append(variable.getName());
    }

    public void visit(MultivectorComponent component) {
        this.code.append(component.getName().replace("_opt", ""));
        this.code.append('[');
        this.code.append(component.getBladeIndex());
        this.code.append(']');
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.code.append("pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.code.append(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.code.append(')');
        }
    }

    protected boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals((Object)exponentiation.getRight());
    }

    public void visit(FloatConstant floatConstant) {
        this.code.append(Double.toString(floatConstant.getValue()));
    }

    public void visit(OuterProduct outerProduct) {
        throw new UnsupportedOperationException("The C/C++ backend does not support the outer product.");
    }

    public void visit(BaseVector baseVector) {
        throw new UnsupportedOperationException("The C/C++ backend does not support base vectors.");
    }

    public void visit(Negation negation) {
        this.code.append('(');
        this.code.append('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.code.append(')');
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("The C/C++ backend does not support the reverse operation.");
    }

    public void visit(LogicalOr node) {
        this.addBinaryInfix((BinaryOperation)node, " || ");
    }

    public void visit(LogicalAnd node) {
        this.addBinaryInfix((BinaryOperation)node, " && ");
    }

    public void visit(LogicalNegation node) {
        this.code.append('!');
        this.addChild((Expression)node, node.getOperand());
    }

    public void visit(Equality node) {
        this.addBinaryInfix((BinaryOperation)node, " == ");
    }

    public void visit(Inequality node) {
        this.addBinaryInfix((BinaryOperation)node, " != ");
    }

    public void visit(Relation relation) {
        this.addBinaryInfix((BinaryOperation)relation, relation.getTypeString());
    }

    public void visit(Macro node) {
        throw new IllegalStateException("Macros should have been inlined and removed from the graph.");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined and no macro calls should be in the graph.");
    }
}

