/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.AlgebraStrategy;
import de.gaalop.CodeParserException;
import de.gaalop.InputFile;
import de.gaalop.OptimizationException;
import de.gaalop.algebra.BaseVectorDefiner;
import de.gaalop.algebra.BaseVectorReplaceVisitor;
import de.gaalop.algebra.BladeArrayRoutines;
import de.gaalop.algebra.Inliner;
import de.gaalop.algebra.MacrosVisitor;
import de.gaalop.algebra.Plugin;
import de.gaalop.algebra.StringIntContainer;
import de.gaalop.algebra.TCBlade;
import de.gaalop.algebra.UpdateLocalVariableSet;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.FindStoreOutputNodes;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.OuterProduct;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlStrategy
implements AlgebraStrategy {
    private Plugin plugin;

    public AlStrategy(Plugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(ControlFlowGraph graph) throws OptimizationException {
        FindStoreOutputNodes outputNodes = new FindStoreOutputNodes();
        graph.accept((ControlFlowVisitor)outputNodes);
        if (outputNodes.getNodes().isEmpty()) {
            throw new OptimizationException("There are no lines marked for optimization ('?')", graph);
        }
        InputStream inputStream = null;
        try {
            String baseDir;
            AlgebraDefinitionFile alFile = graph.getAlgebraDefinitionFile();
            alFile.setUsePrecalculatedTable(this.plugin.usePrecalulatedTables);
            alFile.setUseAsRessource(graph.asRessource);
            String string = baseDir = graph.asRessource ? "algebra" : graph.algebraBaseDirectory;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            baseDir = baseDir + graph.algebraName + "/";
            alFile.setProductsFilePath(baseDir + "products.csv");
            inputStream = graph.asRessource ? this.getClass().getResourceAsStream(baseDir + "definition.csv") : new FileInputStream(new File(baseDir + "definition.csv"));
            alFile.loadFromFile(inputStream);
            AlStrategy.createBlades(alFile);
            inputStream = graph.asRessource ? this.getClass().getResourceAsStream(baseDir + "macros.clu") : new FileInputStream(new File(baseDir + "macros.clu"));
            ControlFlowGraph macrosGraph = new de.gaalop.clucalc.input.Plugin().createCodeParser().parseFile(this.inputStreamToInputFile(inputStream, "macros", null));
            inputStream.close();
            HashMap<StringIntContainer, Macro> macros = MacrosVisitor.getAllMacros(macrosGraph);
            MacrosVisitor.getAllMacros(graph, macros);
            StringIntContainer dual = new StringIntContainer("Dual", 1);
            if (macros.containsKey(dual)) {
                macros.put(new StringIntContainer("*", 1), macros.get(dual));
                macros.remove(dual);
            }
            if (!this.plugin.getUserMacroFilePath().trim().equals("")) {
                File f = new File(this.plugin.userMacroFilePath);
                if (f.exists()) {
                    inputStream = new FileInputStream(f);
                    ControlFlowGraph userMacrosGraph = new de.gaalop.clucalc.input.Plugin().createCodeParser().parseFile(this.inputStreamToInputFile(inputStream, "userMacros", f.getParentFile()));
                    inputStream.close();
                    MacrosVisitor.getAllMacros(userMacrosGraph, macros);
                } else {
                    System.err.println("Algebra Plugin: User Macro File Path does not exist!");
                }
            }
            Inliner.inline(graph, macros);
            for (Macro macro : macros.values()) {
                graph.removeNode((SequentialNode)macro);
            }
            BaseVectorDefiner definer = new BaseVectorDefiner();
            definer.createFromAlBase(alFile.base);
            BaseVectorReplaceVisitor replacerB = new BaseVectorReplaceVisitor(definer);
            graph.accept((ControlFlowVisitor)replacerB);
            UpdateLocalVariableSet.updateVariableSets(graph);
            HashMap<String, Integer> mapIndices = new HashMap<String, Integer>();
            for (int index = 0; index < alFile.blades.length; ++index) {
                mapIndices.put(this.bladeToString(alFile.blades[index]), new Integer(index));
            }
            Set set = graph.getPragmaOutputVariables();
            HashSet copySet = new HashSet(set);
            set.clear();
            for (String str : copySet) {
                if (str.contains(" ")) {
                    String[] parts = str.split(" ");
                    if (parts[1].equals("1")) {
                        parts[1] = "1.0";
                    }
                    if (!mapIndices.containsKey(parts[1])) {
                        throw new OptimizationException("The bladename " + parts[1] + " is not found in the default blade list.", graph);
                    }
                    set.add(parts[0] + "$" + mapIndices.get(parts[1]));
                    continue;
                }
                set.add(str);
            }
        }
        catch (CodeParserException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String bladeToString(Expression blade) {
        if (!blade.isComposite()) {
            return blade.toString();
        }
        OuterProduct outerProduct = (OuterProduct)blade;
        return this.bladeToString(outerProduct.getLeft()) + "^" + this.bladeToString(outerProduct.getRight());
    }

    public static void createBlades(AlgebraDefinitionFile alFile) {
        TCBlade[] blades = BladeArrayRoutines.createBlades(Arrays.copyOfRange(alFile.base, 1, alFile.base.length));
        alFile.blades = new Expression[blades.length];
        for (int i = 0; i < blades.length; ++i) {
            alFile.blades[i] = blades[i].toExpression();
        }
    }

    private InputFile inputStreamToInputFile(InputStream inputStream, String cluName, File parent) {
        StringBuilder sb = new StringBuilder();
        this.readIn(inputStream, sb, parent);
        sb.append("\n");
        return new InputFile(cluName, sb.toString());
    }

    private void readIn(InputStream inputStream, StringBuilder sb, File parent) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#include")) {
                    line = line.trim();
                    String filename = line.substring(line.indexOf(" ") + 1).trim();
                    File newParent = new File(parent, filename);
                    FileInputStream inp = new FileInputStream(newParent);
                    this.readIn(inp, sb, newParent);
                    inp.close();
                } else {
                    sb.append(line);
                }
                sb.append("\n");
            }
            reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(AlStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

