/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.algebra.MacroCallCounter;
import de.gaalop.algebra.MacroVariablesCFGReplacer;
import de.gaalop.algebra.MacroVariablesDFGReplacer;
import de.gaalop.algebra.StringIntContainer;
import de.gaalop.algebra.VariableCollector;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.cfg.UnknownMacroCall;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.DFGTraversalVisitor;
import de.gaalop.visitors.ReplaceVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Inliner
extends EmptyControlFlowVisitor {
    private int count = 0;
    private HashMap<StringIntContainer, Macro> macros;
    private ControlFlowGraph graph;
    private ColorNode currentColorNode = null;
    private SequentialNode curNode;
    private boolean error = false;
    private boolean delete;
    private ReplaceVisitor replacer = new ReplaceVisitor(){

        public void visit(MacroCall node) {
            String macroCallName = node.getName();
            for (MathFunction f : MathFunction.values()) {
                if (!f.name().toLowerCase().equals(macroCallName.toLowerCase())) continue;
                this.result = new MathFunctionCall((Expression)node.getArguments().get(0), f);
                return;
            }
            StringIntContainer container = new StringIntContainer(macroCallName, node.getArguments().size());
            if (!Inliner.this.macros.containsKey(container)) {
                System.err.println("Macro " + macroCallName + " is not defined!");
                Inliner.this.error = true;
                this.result = null;
                Inliner.this.delete = true;
                ((Inliner)Inliner.this).graph.unknownMacros.add(new UnknownMacroCall(node, Inliner.this.currentColorNode));
                ArrayList<Object> newArgs = new ArrayList<Object>(node.getArguments().size());
                for (Expression arg : node.getArguments()) {
                    if (!(arg instanceof Variable) && !(arg instanceof FloatConstant)) {
                        Variable newVariable = Inliner.this.createNewVariable();
                        AssignmentNode assignmentNode = new AssignmentNode(Inliner.this.graph, newVariable, arg);
                        Inliner.this.curNode.insertBefore((SequentialNode)assignmentNode);
                        StoreResultNode storeNode = new StoreResultNode(Inliner.this.graph, newVariable);
                        Inliner.this.curNode.insertBefore((SequentialNode)storeNode);
                        newArgs.add(newVariable);
                        continue;
                    }
                    newArgs.add(arg);
                }
                node.setArgs(newArgs);
                return;
            }
            Macro macro = (Macro)Inliner.this.macros.get(container);
            HashMap<String, Expression> replaceMap = new HashMap<String, Expression>();
            int index = 1;
            for (Expression e : node.getArguments()) {
                replaceMap.put("_P(" + index + ")", e);
                ++index;
            }
            for (SequentialNode sNode : macro.getBody()) {
                AssignmentNode assignmentNode;
                String name;
                if (!(sNode instanceof AssignmentNode) || replaceMap.containsKey(name = (assignmentNode = (AssignmentNode)sNode).getVariable().getName())) continue;
                replaceMap.put(name, (Expression)Inliner.this.createNewVariable());
            }
            for (SequentialNode sNode : macro.getBody()) {
                SequentialNode copySNode = sNode.copy();
                MacroVariablesCFGReplacer r = new MacroVariablesCFGReplacer(replaceMap);
                copySNode.accept((ControlFlowVisitor)r);
                Inliner.this.curNode.insertBefore(copySNode);
            }
            Expression copiedReturnVal = macro.getReturnValue().copy();
            MacroVariablesDFGReplacer d = new MacroVariablesDFGReplacer(replaceMap);
            copiedReturnVal.accept((ExpressionVisitor)d);
            this.result = copiedReturnVal;
        }
    };

    private boolean containsMacroCall(Expression e) {
        final LinkedList calls = new LinkedList();
        e.accept((ExpressionVisitor)new DFGTraversalVisitor(){

            public void visit(MacroCall node) {
                calls.add(node);
            }
        });
        return !calls.isEmpty();
    }

    private Inliner(HashMap<StringIntContainer, Macro> macros, ControlFlowGraph graph) {
        this.macros = macros;
        this.graph = graph;
    }

    public static void inline(ControlFlowGraph graph, HashMap<StringIntContainer, Macro> macros) {
        Inliner inliner = new Inliner(macros, graph);
        while (!inliner.error && MacroCallCounter.countMacroCallsInGraph(graph) > 0) {
            graph.accept((ControlFlowVisitor)inliner);
        }
    }

    public void visit(ColorNode node) {
        StoreResultNode storeNode;
        AssignmentNode assignmentNode;
        Variable newVariable;
        this.curNode = node;
        Expression c = node.getR();
        if (!(c instanceof Variable) && !(c instanceof FloatConstant)) {
            newVariable = this.createNewVariable();
            assignmentNode = new AssignmentNode(this.graph, newVariable, c);
            this.curNode.insertBefore((SequentialNode)assignmentNode);
            storeNode = new StoreResultNode(this.graph, newVariable);
            this.curNode.insertBefore((SequentialNode)storeNode);
            node.setR((Expression)newVariable);
        }
        if (!((c = node.getG()) instanceof Variable) && !(c instanceof FloatConstant)) {
            newVariable = this.createNewVariable();
            assignmentNode = new AssignmentNode(this.graph, newVariable, c);
            this.curNode.insertBefore((SequentialNode)assignmentNode);
            storeNode = new StoreResultNode(this.graph, newVariable);
            this.curNode.insertBefore((SequentialNode)storeNode);
            node.setG((Expression)newVariable);
        }
        if (!((c = node.getB()) instanceof Variable) && !(c instanceof FloatConstant)) {
            newVariable = this.createNewVariable();
            assignmentNode = new AssignmentNode(this.graph, newVariable, c);
            this.curNode.insertBefore((SequentialNode)assignmentNode);
            storeNode = new StoreResultNode(this.graph, newVariable);
            this.curNode.insertBefore((SequentialNode)storeNode);
            node.setB((Expression)newVariable);
        }
        if (!((c = node.getAlpha()) instanceof Variable) && !(c instanceof FloatConstant)) {
            newVariable = this.createNewVariable();
            assignmentNode = new AssignmentNode(this.graph, newVariable, c);
            this.curNode.insertBefore((SequentialNode)assignmentNode);
            storeNode = new StoreResultNode(this.graph, newVariable);
            this.curNode.insertBefore((SequentialNode)storeNode);
            node.setAlpha((Expression)newVariable);
        }
        this.currentColorNode = node;
        super.visit(node);
    }

    private Inliner() {
    }

    public void visit(AssignmentNode node) {
        this.curNode = node;
        while (this.containsMacroCall(node.getValue()) && !this.error) {
            this.replacer.result = null;
            node.getValue().accept((ExpressionVisitor)this.replacer);
            if (this.replacer.result == null) continue;
            node.setValue(this.replacer.result);
        }
        super.visit(node);
    }

    public void visit(ExpressionStatement node) {
        this.curNode = node;
        this.replacer.result = null;
        this.delete = false;
        node.getExpression().accept((ExpressionVisitor)this.replacer);
        boolean del = this.delete;
        Expression result = this.replacer.result;
        if (result != null) {
            node.setExpression(result);
        }
        super.visit(node);
        if (del) {
            this.graph.removeNode((SequentialNode)node);
        }
    }

    private Variable createNewVariable() {
        VariableCollector collector = new VariableCollector();
        this.graph.accept((ControlFlowVisitor)collector);
        ++this.count;
        while (collector.getVariables().contains("macroUniqueName" + this.count)) {
            ++this.count;
        }
        return new Variable("macroUniqueName" + this.count);
    }
}

