/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.algebra;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.DFGTraversalVisitor;
import java.util.HashSet;
import java.util.LinkedList;

public class UpdateLocalVariableSet
extends EmptyControlFlowVisitor {
    private HashSet<String> inputVariables = new HashSet();
    private HashSet<String> defined = new HashSet();
    private DFGTraversalVisitor dfgVisitor = new DFGTraversalVisitor(){

        public void visit(Variable node) {
            if (!UpdateLocalVariableSet.this.defined.contains(node.getName())) {
                UpdateLocalVariableSet.this.inputVariables.add(node.getName());
            }
            super.visit(node);
        }

        public void visit(MultivectorComponent node) {
            if (!UpdateLocalVariableSet.this.defined.contains(node.getName())) {
                UpdateLocalVariableSet.this.inputVariables.add(node.getName());
            }
            super.visit(node);
        }
    };

    private UpdateLocalVariableSet() {
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this.dfgVisitor);
        this.defined.add(node.getVariable().getName());
        super.visit(node);
    }

    public static void updateVariableSets(ControlFlowGraph graph) {
        UpdateLocalVariableSet visitor = new UpdateLocalVariableSet();
        graph.accept((ControlFlowVisitor)visitor);
        LinkedList iVar = new LinkedList(graph.getInputVariables());
        LinkedList lVar = new LinkedList(graph.getLocalVariables());
        for (Variable variable : iVar) {
            graph.removeInputVariable(variable);
        }
        for (Variable variable : lVar) {
            graph.removeLocalVariable(variable);
        }
        for (String string : visitor.inputVariables) {
            graph.addInputVariable(new Variable(string));
        }
        for (String string : visitor.defined) {
            graph.addLocalVariable(new Variable(string));
        }
    }
}

