/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

public class BitSet {
    private long bits = 0L;

    public BitSet(int bitCount) {
    }

    public boolean get(int bit) {
        return (this.bits & (long)(1 << bit)) != 0L;
    }

    public void set(int bit) {
        this.bits |= (long)(1 << bit);
    }

    public void clear() {
        this.bits = 0L;
    }

    public void or(BitSet bitSet) {
        this.bits |= bitSet.bits;
    }

    public void xor(BitSet bitSet) {
        this.bits ^= bitSet.bits;
    }

    public void and(BitSet bitSet) {
        this.bits &= bitSet.bits;
    }

    public void shiftRight() {
        this.bits >>= 1;
    }

    public int cardinality() {
        return Long.bitCount(this.bits);
    }

    public boolean intersects(BitSet bitSet) {
        return (this.bits & bitSet.bits) != 0L;
    }

    public boolean isEmpty() {
        return this.bits == 0L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet other = (BitSet)obj;
        return other.bits == this.bits;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (int)(this.bits ^ this.bits >>> 32);
        return hash;
    }
}

