/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.productComputer.AlgebraPC;
import de.gaalop.productComputer.BaseTransformation;
import de.gaalop.productComputer.Blade;
import de.gaalop.productComputer.BladeStr;
import de.gaalop.productComputer.BubbleSort;
import de.gaalop.productComputer.ProductCalculator;
import de.gaalop.productComputer.SignedBlade;
import de.gaalop.productComputer.SumOfBlades;
import de.gaalop.tba.Multivector;
import java.util.HashMap;
import java.util.LinkedList;

public class ProductComputer {
    private int bitCount;
    private byte[] squareMask;
    private HashMap<Integer, SumOfBlades> mapZIToPM;
    private HashMap<Integer, SumOfBlades> mapPMToZI;
    private SumOfBlades[] bladeListPM;
    private HashMap<Blade, Integer> mapBladeToIndex;

    private int getIndex(String element, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!element.equals(arr[i])) continue;
            return i;
        }
        return -1;
    }

    private SignedBlade bladeStrToSignedBlade(BladeStr bladeStr, String[] base) {
        SignedBlade sBlade = new SignedBlade(this.bitCount, bladeStr.getPrefactor());
        Integer[] arr = new Integer[bladeStr.getBaseVectors().length];
        int i = 0;
        for (String baseVector : bladeStr.getBaseVectors()) {
            int index = this.getIndex(baseVector, base);
            arr[i] = index;
            sBlade.set(index);
            ++i;
        }
        if (BubbleSort.doBubbleSort(arr) % 2 == 1) {
            sBlade.coefficient *= -1.0f;
        }
        return sBlade;
    }

    private void initializeMap(String[] base, String[] base2, HashMap<String, LinkedList<BladeStr>> source, HashMap<Integer, SumOfBlades> dest) {
        for (String baseElement : source.keySet()) {
            LinkedList<BladeStr> list = source.get(baseElement);
            SumOfBlades sumOfBlades = new SumOfBlades();
            for (BladeStr element : list) {
                sumOfBlades.add(this.bladeStrToSignedBlade(element, base));
            }
            dest.put(this.getIndex(baseElement, base2), sumOfBlades);
        }
    }

    private void createBladesHelp(Blade arrTrailing, int startPos, int k, LinkedList<SumOfBlades> bladelist) {
        if (k == 1) {
            for (int s = startPos; s < this.bitCount; ++s) {
                Blade nbase = new Blade(this.bitCount, arrTrailing);
                nbase.set(s);
                SumOfBlades su = new SumOfBlades();
                su.add(new SignedBlade(this.bitCount, nbase));
                bladelist.add(su);
            }
        } else {
            for (int s = startPos; s < this.bitCount - 1; ++s) {
                Blade nbase = new Blade(this.bitCount, arrTrailing);
                nbase.set(s);
                this.createBladesHelp(nbase, s + 1, k - 1, bladelist);
            }
        }
    }

    public void initialize(AlgebraPC algebraPC) {
        this.bitCount = algebraPC.base.length;
        this.squareMask = new byte[algebraPC.base2.length];
        for (int index = 0; index < algebraPC.base2.length; ++index) {
            this.squareMask[index] = algebraPC.baseSquaresStr.get(algebraPC.base2[index]);
        }
        this.mapZIToPM = new HashMap();
        this.initializeMap(algebraPC.base2, algebraPC.base, algebraPC.mapToPlusMinus, this.mapZIToPM);
        this.mapPMToZI = new HashMap();
        this.initializeMap(algebraPC.base, algebraPC.base2, algebraPC.mapToZeroInf, this.mapPMToZI);
        LinkedList<SumOfBlades> bladeListZI = new LinkedList<SumOfBlades>();
        SumOfBlades s1 = new SumOfBlades();
        s1.add(new SignedBlade(this.bitCount));
        bladeListZI.add(s1);
        for (int k = 1; k <= this.bitCount; ++k) {
            Blade list1 = new Blade(this.bitCount);
            this.createBladesHelp(list1, 0, k, bladeListZI);
        }
        this.bladeListPM = new SumOfBlades[bladeListZI.size()];
        this.mapBladeToIndex = new HashMap();
        int i = 0;
        for (SumOfBlades s : bladeListZI) {
            SignedBlade sb = (SignedBlade)s.getFirst();
            this.mapBladeToIndex.put(new Blade(this.bitCount, sb), new Integer(i));
            this.bladeListPM[i] = BaseTransformation.transform(s, this.mapZIToPM, this.bitCount);
            ++i;
        }
    }

    private void group(SumOfBlades sumOfBlades) {
        HashMap<Blade, Float> map = new HashMap<Blade, Float>();
        for (SignedBlade sb : sumOfBlades) {
            Blade b = new Blade(this.bitCount, sb);
            if (map.containsKey(b)) {
                map.put(b, Float.valueOf(((Float)map.get(b)).floatValue() + sb.coefficient));
                continue;
            }
            map.put(b, Float.valueOf(sb.coefficient));
        }
        sumOfBlades.clear();
        for (Blade b : map.keySet()) {
            float prefactor = ((Float)map.get(b)).floatValue();
            if (!((double)Math.abs(prefactor) > 0.001)) continue;
            sumOfBlades.add(new SignedBlade(this.bitCount, b, prefactor));
        }
    }

    public Multivector calcProduct(Integer factor1, Integer factor2, ProductCalculator calculator) {
        SumOfBlades s1 = this.bladeListPM[factor1];
        SumOfBlades s2 = this.bladeListPM[factor2];
        SumOfBlades product = new SumOfBlades();
        for (SignedBlade b1 : s1) {
            for (SignedBlade b2 : s2) {
                calculator.calcProduct(b1, b2, product, this.bitCount, this.squareMask);
            }
        }
        product = BaseTransformation.transform(product, this.mapPMToZI, this.bitCount);
        this.group(product);
        return product.toMultivector(this.mapBladeToIndex, this.bitCount);
    }
}

