/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba;

import de.gaalop.algebra.TCBlade;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.dfg.Expression;
import de.gaalop.tba.Blade;
import java.util.HashMap;
import java.util.Vector;

public class Algebra {
    private String[] base;
    private Vector<Blade> blades = new Vector();
    private HashMap<Blade, Integer> indices = new HashMap();
    private boolean dirty;

    public Algebra() {
        this.dirty = true;
    }

    public Algebra(String[] base, TCBlade[] blades) {
        this.base = base;
        for (TCBlade b : blades) {
            this.blades.add(new Blade(b));
        }
        this.dirty = true;
    }

    public Algebra(AlgebraDefinitionFile alFile) {
        this.base = alFile.base;
        for (Expression e : alFile.blades) {
            this.blades.add(Blade.createBladeFromExpression(e));
        }
        this.dirty = true;
    }

    public int getBladeCount() {
        return this.blades.size();
    }

    public Blade getBlade(int index) {
        if (index < this.blades.size()) {
            return this.blades.get(index);
        }
        return this.blades.get(0);
    }

    public void setBlade(int index, Blade bladeExpr) {
        if (index > this.blades.size() - 1) {
            this.blades.setSize(index + 1);
        }
        this.blades.set(index, bladeExpr);
        this.dirty = true;
    }

    public int getIndex(Blade bladeExpr) {
        if (this.dirty) {
            this.buildMap();
        }
        if (bladeExpr.getBases().isEmpty()) {
            return 0;
        }
        return this.indices.get(bladeExpr);
    }

    public String[] getBase() {
        return this.base;
    }

    public void setBase(String[] base) {
        this.base = base;
    }

    public int getBaseCount() {
        return this.base.length - 1;
    }

    public void buildMap() {
        this.indices.clear();
        int i = 0;
        for (Blade b : this.blades) {
            this.indices.put(b, i++);
        }
        this.dirty = false;
    }
}

