/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba;

import de.gaalop.algebra.TCBlade;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionFactory;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.visitors.DFGTraversalVisitor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class Blade {
    private Vector<String> bases;

    public Blade() {
        this.bases = new Vector();
    }

    public Blade(String[] bases) {
        this.bases = new Vector<String>(Arrays.asList(bases));
    }

    public Blade(Vector<String> bases) {
        this.bases = bases;
    }

    public Blade(TCBlade b) {
        this.bases = new Vector<String>(Arrays.asList(b.getBase()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String b : this.bases) {
            sb.append("^" + b);
        }
        if (this.bases.size() > 0) {
            return sb.substring(1);
        }
        return "1.0";
    }

    public void addBasis(String toAdd) {
        this.bases.add(toAdd);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Blade) {
            Blade comp = (Blade)obj;
            return this.bases.equals(comp.bases);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.bases != null ? this.bases.hashCode() : 0);
        return hash;
    }

    public Vector<String> getBases() {
        return this.bases;
    }

    public Expression getExpression() {
        if (this.bases.size() >= 1) {
            Expression result = this.getBaseVector(this.bases.get(0));
            for (int i = 1; i < this.bases.size(); ++i) {
                result = ExpressionFactory.wedge((Expression[])new Expression[]{result, this.getBaseVector(this.bases.get(i))});
            }
            return result;
        }
        throw new IllegalStateException("Blade: Blade contains no base element!");
    }

    private Expression getBaseVector(String string) {
        if (string.equals("1")) {
            return new FloatConstant(1.0);
        }
        return new BaseVector(string.substring(1));
    }

    public static Blade createBladeFromExpression(Expression expr) {
        final LinkedList list = new LinkedList();
        DFGTraversalVisitor visitor = new DFGTraversalVisitor(){

            public void visit(BaseVector node) {
                list.add(node.toString());
                super.visit(node);
            }
        };
        expr.accept((ExpressionVisitor)visitor);
        return new Blade(list.toArray(new String[0]));
    }
}

