/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba;

import de.gaalop.tba.Algebra;
import de.gaalop.tba.BladeRef;
import java.util.Arrays;
import java.util.Vector;

public class Multivector {
    private Vector<BladeRef> blades = new Vector();

    public void addBlade(BladeRef blade) {
        this.blades.add(blade);
    }

    public byte[] getValueArr(Algebra algebra) {
        int size = algebra.getBladeCount();
        byte[] result = new byte[size];
        Arrays.fill(result, (byte)0);
        for (BladeRef cur : this.blades) {
            int n = cur.getIndex();
            result[n] = (byte)(result[n] + cur.getPrefactor());
        }
        return result;
    }

    public String toString() {
        return this.blades.toString();
    }

    public Vector<BladeRef> getBlades() {
        return this.blades;
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        block5: for (BladeRef ref : this.blades) {
            switch (ref.getPrefactor()) {
                case -1: {
                    sb.append("-E" + ref.getIndex());
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                case 1: {
                    sb.append("+E" + ref.getIndex());
                    continue block5;
                }
            }
            System.err.println("Only -1,0,1 allowed as prefactors in multivectors");
        }
        if (sb.length() == 0) {
            return "";
        }
        if (sb.charAt(0) == '+') {
            return sb.substring(1);
        }
        return sb.toString();
    }
}

