/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport;

import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.Algebra;
import de.gaalop.tba.Multivector;
import de.gaalop.tba.Products;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.MvExpressions;
import java.util.HashMap;

public class MvExpressionsBuilder
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    public HashMap<String, MvExpressions> variables;
    public HashMap<Expression, MvExpressions> expressions;
    private int counterMv;
    public int bladeCount;
    private UseAlgebra usedAlgebra;
    private final double EPSILON = 1.0E-6;
    private boolean scalarFunctions;
    private Variable curVariable;
    private AlgebraDefinitionFile alFile;

    public MvExpressionsBuilder(UseAlgebra usedAlgebra, boolean scalarFunctions, AlgebraDefinitionFile alFile) {
        this.scalarFunctions = scalarFunctions;
        this.alFile = alFile;
        this.variables = new HashMap();
        this.usedAlgebra = usedAlgebra;
        this.counterMv = 0;
        this.bladeCount = usedAlgebra.getBladeCount();
        this.expressions = new HashMap();
    }

    protected AssignmentNode changeGraph(AssignmentNode node, MvExpressions mvExpr, Variable variable) {
        return node;
    }

    public void visit(AssignmentNode node) {
        this.curVariable = node.getVariable();
        Expression value = node.getValue();
        value.accept((ExpressionVisitor)this);
        MvExpressions mvExpr = this.expressions.get(value);
        this.variables.put(this.curVariable.toString(), mvExpr);
        AssignmentNode lastNode = node;
        if (this.scalarFunctions) {
            lastNode = this.changeGraph(node, mvExpr, this.curVariable);
        } else if (!(value instanceof MathFunctionCall)) {
            lastNode = this.changeGraph(node, mvExpr, this.curVariable);
        }
        lastNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    private MvExpressions createNewMvExpressions() {
        ++this.counterMv;
        return new MvExpressions(this.counterMv + "", this.bladeCount);
    }

    private MvExpressions calculateUsingMultTable(Products typeProduct, MvExpressions left, MvExpressions right) {
        MvExpressions result = this.createNewMvExpressions();
        Algebra algebra = this.usedAlgebra.getAlgebra();
        boolean set = false;
        for (int bladeL = 0; bladeL < this.bladeCount; ++bladeL) {
            if (left.bladeExpressions[bladeL] == null) continue;
            for (int bladeR = 0; bladeR < this.bladeCount; ++bladeR) {
                if (right.bladeExpressions[bladeR] == null) continue;
                Multiplication prodExpr = new Multiplication(left.bladeExpressions[bladeL], right.bladeExpressions[bladeR]);
                Multivector prodMv = this.usedAlgebra.getProduct(typeProduct, bladeL, bladeR);
                byte[] prod = prodMv.getValueArr(algebra);
                for (int bladeResult = 0; bladeResult < this.bladeCount; ++bladeResult) {
                    if (!((double)Math.abs(prod[bladeResult]) > 1.0E-6)) continue;
                    Multiplication prodExpri = new Multiplication((Expression)prodExpr, (Expression)new FloatConstant((double)prod[bladeResult]));
                    if (result.bladeExpressions[bladeResult] == null) {
                        set = true;
                        result.bladeExpressions[bladeResult] = prodExpri;
                        continue;
                    }
                    result.bladeExpressions[bladeResult] = new Addition(result.bladeExpressions[bladeResult], (Expression)prodExpri);
                }
            }
        }
        if (!set) {
            result.bladeExpressions[0] = new FloatConstant(0.0);
        }
        return result;
    }

    private void calculateUsingMultTable(Products typeProduct, BinaryOperation node) {
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.calculateUsingMultTable(typeProduct, left, right);
        this.expressions.put((Expression)node, result);
    }

    private void traverseBinary(BinaryOperation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    private void traverseUnary(UnaryOperation node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Subtraction node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        for (int blade = 0; blade < this.bladeCount; ++blade) {
            if (left.bladeExpressions[blade] != null) {
                if (right.bladeExpressions[blade] != null) {
                    result.bladeExpressions[blade] = new Subtraction(left.bladeExpressions[blade], right.bladeExpressions[blade]);
                    continue;
                }
                result.bladeExpressions[blade] = left.bladeExpressions[blade];
                continue;
            }
            if (right.bladeExpressions[blade] == null) continue;
            result.bladeExpressions[blade] = new Negation(right.bladeExpressions[blade]);
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(Addition node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        for (int blade = 0; blade < this.bladeCount; ++blade) {
            if (left.bladeExpressions[blade] != null) {
                if (right.bladeExpressions[blade] != null) {
                    result.bladeExpressions[blade] = new Addition(left.bladeExpressions[blade], right.bladeExpressions[blade]);
                    continue;
                }
                result.bladeExpressions[blade] = left.bladeExpressions[blade];
                continue;
            }
            if (right.bladeExpressions[blade] == null) continue;
            result.bladeExpressions[blade] = right.bladeExpressions[blade];
        }
        this.expressions.put((Expression)node, result);
    }

    private MvExpressions getReverse(MvExpressions mv) {
        MvExpressions result = this.createNewMvExpressions();
        for (int blade = 0; blade < this.bladeCount; ++blade) {
            if (mv.bladeExpressions[blade] == null) continue;
            int k = this.usedAlgebra.getGrade(blade);
            result.bladeExpressions[blade] = k * (k - 1) / 2 % 2 == 0 ? mv.bladeExpressions[blade] : new Negation(mv.bladeExpressions[blade]);
        }
        return result;
    }

    private MvExpressions getInverse(MvExpressions mv) {
        MvExpressions revR = this.getReverse(mv);
        MvExpressions length = this.calculateUsingMultTable(Products.GEO, mv, revR);
        MvExpressions result = this.createNewMvExpressions();
        for (int blade = 0; blade < this.bladeCount; ++blade) {
            if (mv.bladeExpressions[blade] == null) continue;
            result.bladeExpressions[blade] = new Division(revR.bladeExpressions[blade].copy(), length.bladeExpressions[0]);
        }
        return result;
    }

    public void visit(Division node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions inverse = this.getInverse(r);
        MvExpressions result = this.calculateUsingMultTable(Products.GEO, l, inverse);
        this.expressions.put((Expression)node, result);
    }

    public void visit(InnerProduct node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.INNER, (BinaryOperation)node);
    }

    public void visit(Multiplication node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.GEO, (BinaryOperation)node);
    }

    public void visit(MathFunctionCall node) {
        MvExpressions result = this.createNewMvExpressions();
        if (this.scalarFunctions) {
            this.traverseUnary((UnaryOperation)node);
            switch (node.getFunction()) {
                case ABS: {
                    MvExpressions op = this.expressions.get(node.getOperand());
                    MvExpressions opR = this.getReverse(op);
                    MvExpressions prod = this.calculateUsingMultTable(Products.GEO, op, opR);
                    Expression i0 = prod.bladeExpressions[0];
                    if (i0 == null) {
                        i0 = new FloatConstant(0.0);
                    }
                    result.bladeExpressions[0] = new MathFunctionCall((Expression)new MathFunctionCall(i0, MathFunction.ABS), MathFunction.SQRT);
                    break;
                }
                case SQRT: {
                    result.bladeExpressions[0] = new MathFunctionCall(this.expressions.get((Object)node.getOperand()).bladeExpressions[0], MathFunction.SQRT);
                    break;
                }
                default: {
                    result.bladeExpressions[0] = new MathFunctionCall(this.expressions.get((Object)node.getOperand()).bladeExpressions[0], node.getFunction());
                    System.err.println("Warning: " + node.getFunction().toString() + " is only implemented for scalar inputs!");
                    break;
                }
            }
        } else {
            for (int blade = 0; blade < this.bladeCount; ++blade) {
                result.bladeExpressions[blade] = new MultivectorComponent(this.curVariable.getName(), blade);
            }
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(Variable node) {
        MvExpressions v = null;
        String key = node.toString();
        if (this.variables.containsKey(key)) {
            v = this.createNewMvExpressions();
            for (int i = 0; i < this.bladeCount; ++i) {
                if (this.variables.get((Object)key).bladeExpressions[i] == null) continue;
                v.bladeExpressions[i] = new MultivectorComponent(node.getName(), i);
            }
        } else {
            v = this.createNewMvExpressions();
            v.bladeExpressions[0] = node;
        }
        this.expressions.put((Expression)node, v);
    }

    public void visit(MultivectorComponent node) {
        this.expressions.put((Expression)node, this.variables.get(node.toString()));
    }

    public void visit(FloatConstant node) {
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = node;
        this.expressions.put((Expression)node, result);
    }

    public void visit(OuterProduct node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.OUTER, (BinaryOperation)node);
    }

    public void visit(BaseVector node) {
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[this.alFile.getIndex((String)node.toString())] = new FloatConstant(1.0);
        this.expressions.put((Expression)node, result);
    }

    public void visit(Negation node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.createNewMvExpressions();
        for (int blade = 0; blade < this.bladeCount; ++blade) {
            if (op.bladeExpressions[blade] == null) continue;
            result.bladeExpressions[blade] = new Negation(op.bladeExpressions[blade]);
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(Reverse node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.getReverse(op);
        this.expressions.put((Expression)node, result);
    }

    public void visit(LogicalOr node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new LogicalOr(l.bladeExpressions[0], r.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalOr is only implemented for scalars!");
    }

    public void visit(LogicalAnd node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new LogicalAnd(l.bladeExpressions[0], r.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalAnd is only implemented for scalars!");
    }

    public void visit(LogicalNegation node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new LogicalNegation(op.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalNegation is only implemented for scalars!");
    }

    public void visit(Equality node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new Equality(l.bladeExpressions[0], r.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Equality is only implemented for scalars!");
    }

    public void visit(Inequality node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new Inequality(l.bladeExpressions[0], r.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Inequality is only implemented for scalars!");
    }

    public void visit(Relation node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new Relation(l.bladeExpressions[0], r.bladeExpressions[0], node.getType());
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Relation is only implemented for scalars!");
    }

    public void visit(Exponentiation node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions[0] = new Exponentiation(l.bladeExpressions[0], r.bladeExpressions[0]);
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Exponentiation is only implemented for scalars!");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined and no macro calls should be in the graph.");
    }
}

