/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.api.dfg.DFGNodeType;
import de.gaalop.api.dfg.DFGNodeTypeGetter;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;

public class ConstantFolding
implements ExpressionVisitor,
ControlFlowVisitor {
    private Expression resultExpr;
    private static final double EPSILON = 1.0E-9;
    private boolean graphModified = false;

    public Expression getResultExpr() {
        return this.resultExpr;
    }

    public boolean isGraphModified() {
        return this.graphModified;
    }

    private void setGraphModified() {
        this.graphModified = true;
    }

    private boolean doubleEquals(double val1, double val2) {
        return Math.abs(val1 - val2) <= 1.0E-9;
    }

    private boolean isConstant(Expression expr) {
        return DFGNodeTypeGetter.getTypeOfDFGNode(expr) == DFGNodeType.FloatConstant;
    }

    public void visit(Subtraction node) {
        FloatConstant rightc;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Subtraction(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc2 = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() - rightc2.getValue());
            this.setGraphModified();
        } else if (DFGNodeTypeGetter.getTypeOfDFGNode(right) == DFGNodeType.Negation) {
            Negation neg = (Negation)right;
            this.resultExpr = new Addition(left, neg.getOperand());
            this.setGraphModified();
        } else if (this.isConstant(left)) {
            FloatConstant leftc = (FloatConstant)left;
            if (this.doubleEquals(leftc.getValue(), 0.0)) {
                this.resultExpr = new Negation(right);
                this.setGraphModified();
            }
        } else if (this.isConstant(right) && this.doubleEquals((rightc = (FloatConstant)right).getValue(), 0.0)) {
            this.resultExpr = left;
            this.setGraphModified();
        }
    }

    public void visit(Addition node) {
        FloatConstant rightc;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Addition(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc2 = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() + rightc2.getValue());
            this.setGraphModified();
        } else if (this.isConstant(left)) {
            FloatConstant leftc = (FloatConstant)left;
            if (this.doubleEquals(leftc.getValue(), 0.0)) {
                this.resultExpr = right;
                this.setGraphModified();
            }
        } else if (this.isConstant(right) && this.doubleEquals((rightc = (FloatConstant)right).getValue(), 0.0)) {
            this.resultExpr = left;
            this.setGraphModified();
        }
    }

    public void visit(Division node) {
        FloatConstant floatConst;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Division(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() / rightc.getValue());
            this.setGraphModified();
        } else if (this.isConstant(node.getRight()) && this.doubleEquals((floatConst = (FloatConstant)node.getRight()).getValue(), 1.0)) {
            this.resultExpr = left;
            this.setGraphModified();
        }
    }

    public void visit(InnerProduct node) {
        this.resultExpr = node;
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Multiplication(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant(leftc.getValue() * rightc.getValue());
            this.setGraphModified();
        } else if (this.isConstant(right)) {
            FloatConstant floatConst = (FloatConstant)right;
            if (this.doubleEquals(floatConst.getValue(), 1.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), 0.5)) {
                this.resultExpr = new Division(left, (Expression)new FloatConstant(2.0));
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), -1.0)) {
                this.resultExpr = new Negation(left);
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), 0.0)) {
                this.resultExpr = right;
                this.setGraphModified();
            }
        } else if (this.isConstant(left)) {
            FloatConstant floatConst = (FloatConstant)left;
            if (this.doubleEquals(floatConst.getValue(), 1.0)) {
                this.resultExpr = right;
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), 0.5)) {
                this.resultExpr = new Division(right, (Expression)new FloatConstant(2.0));
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), -1.0)) {
                this.resultExpr = new Negation(right);
                this.setGraphModified();
            } else if (this.doubleEquals(floatConst.getValue(), 0.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            }
        } else if (DFGNodeTypeGetter.getTypeOfDFGNode(left) == DFGNodeType.MathFunctionCall && DFGNodeTypeGetter.getTypeOfDFGNode(right) == DFGNodeType.MathFunctionCall) {
            MathFunctionCall leftFunc = (MathFunctionCall)left;
            MathFunctionCall rightFunc = (MathFunctionCall)right;
            if (leftFunc.getFunction() == MathFunction.ABS && rightFunc.getFunction() == MathFunction.ABS) {
                this.resultExpr = new MathFunctionCall((Expression)new Multiplication(rightFunc.getOperand(), leftFunc.getOperand()), MathFunction.ABS);
                this.setGraphModified();
            }
            if (leftFunc.getFunction() == MathFunction.SQRT && rightFunc.getFunction() == MathFunction.SQRT) {
                this.resultExpr = new MathFunctionCall((Expression)new Multiplication(rightFunc.getOperand(), leftFunc.getOperand()), MathFunction.SQRT);
                this.setGraphModified();
            }
        }
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        Expression operandExpr = this.resultExpr;
        this.resultExpr = new MathFunctionCall(operandExpr, node.getFunction());
        if (node.getFunction() == MathFunction.SQRT && this.isConstant(operandExpr)) {
            FloatConstant operand = (FloatConstant)operandExpr;
            this.resultExpr = new FloatConstant(Math.sqrt(operand.getValue()));
            this.setGraphModified();
        } else if (node.getFunction() == MathFunction.ABS && DFGNodeTypeGetter.getTypeOfDFGNode(operandExpr) == DFGNodeType.MathFunctionCall) {
            MathFunctionCall insideFunc = (MathFunctionCall)operandExpr;
            if (insideFunc.getFunction() == MathFunction.ABS || insideFunc.getFunction() == MathFunction.SQRT) {
                this.resultExpr = operandExpr;
                this.setGraphModified();
            }
        } else if (node.getFunction() == MathFunction.ABS && this.isConstant(operandExpr)) {
            FloatConstant operand = (FloatConstant)operandExpr;
            this.resultExpr = new FloatConstant(Math.abs(operand.getValue()));
            this.setGraphModified();
        }
    }

    public void visit(Variable node) {
        this.resultExpr = node;
    }

    public void visit(MultivectorComponent node) {
        this.resultExpr = node;
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Exponentiation(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = new FloatConstant((double)new Float(Math.pow(leftc.getValue(), rightc.getValue())).floatValue());
            this.setGraphModified();
        } else if (this.isConstant(left) && this.doubleEquals(((FloatConstant)left).getValue(), 0.0)) {
            this.resultExpr = left;
            this.setGraphModified();
        } else if (this.isConstant(right)) {
            MathFunctionCall newsqrt;
            FloatConstant rightc = (FloatConstant)right;
            boolean isSqrt = this.doubleEquals(rightc.getValue() - (double)new Double(rightc.getValue()).intValue(), 0.5);
            if (isSqrt && !this.doubleEquals(rightc.getValue(), 0.5)) {
                newsqrt = new MathFunctionCall((Expression)new Exponentiation(left, (Expression)new FloatConstant(rightc.getValue() - 0.5)), MathFunction.SQRT);
                this.resultExpr = newsqrt;
                this.setGraphModified();
            }
            if (this.doubleEquals(rightc.getValue(), 1.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            } else if (this.doubleEquals(rightc.getValue(), 0.5)) {
                newsqrt = new MathFunctionCall(left, MathFunction.SQRT);
                newsqrt.accept((ExpressionVisitor)this);
                this.setGraphModified();
            } else if (this.doubleEquals(rightc.getValue(), 2.0)) {
                this.resultExpr = new Multiplication(left, left);
                this.setGraphModified();
            }
        }
    }

    public void visit(FloatConstant node) {
        this.resultExpr = node;
    }

    public void visit(OuterProduct node) {
        this.resultExpr = node;
    }

    public void visit(BaseVector node) {
        this.resultExpr = node;
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        Expression operandExpr = this.resultExpr;
        this.resultExpr = new Negation(this.resultExpr);
        if (this.isConstant(operandExpr)) {
            FloatConstant operand = (FloatConstant)operandExpr;
            this.resultExpr = this.doubleEquals(operand.getValue(), 0.0) ? new FloatConstant(0.0) : new FloatConstant(-operand.getValue());
            this.setGraphModified();
        } else if (DFGNodeTypeGetter.getTypeOfDFGNode(operandExpr) == DFGNodeType.Negation) {
            Negation operand = (Negation)operandExpr;
            this.resultExpr = operand.getOperand();
            this.setGraphModified();
        }
    }

    public void visit(Reverse node) {
        this.resultExpr = node;
    }

    public void visit(LogicalOr node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new LogicalOr(left, right);
        if (this.isConstant(left)) {
            FloatConstant leftc = (FloatConstant)left;
            if (this.doubleEquals(leftc.getValue(), 0.0)) {
                this.resultExpr = right;
                this.setGraphModified();
            }
            if (this.doubleEquals(leftc.getValue(), 1.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            }
        } else if (this.isConstant(right)) {
            FloatConstant rightc = (FloatConstant)right;
            if (this.doubleEquals(rightc.getValue(), 0.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            }
            if (this.doubleEquals(rightc.getValue(), 1.0)) {
                this.resultExpr = right;
                this.setGraphModified();
            }
        }
    }

    public void visit(LogicalAnd node) {
        FloatConstant rightc;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new LogicalAnd(left, right);
        if (this.isConstant(left)) {
            FloatConstant leftc = (FloatConstant)left;
            if (this.isConstant(right)) {
                FloatConstant rightc2 = (FloatConstant)right;
                this.resultExpr = this.doubleEquals(leftc.getValue(), 1.0) && this.doubleEquals(rightc2.getValue(), 1.0) ? left : new FloatConstant(0.0);
                this.setGraphModified();
            } else if (this.doubleEquals(leftc.getValue(), 0.0)) {
                this.resultExpr = left;
                this.setGraphModified();
            }
        } else if (this.isConstant(right) && this.doubleEquals((rightc = (FloatConstant)right).getValue(), 0.0)) {
            this.resultExpr = right;
            this.setGraphModified();
        }
    }

    public void visit(Equality node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Equality(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = this.doubleEquals(leftc.getValue(), rightc.getValue()) ? new FloatConstant(1.0) : new FloatConstant(0.0);
            this.setGraphModified();
        }
    }

    public void visit(Inequality node) {
        node.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        node.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Inequality(left, right);
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            this.resultExpr = this.doubleEquals(leftc.getValue(), rightc.getValue()) ? new FloatConstant(0.0) : new FloatConstant(1.0);
            this.setGraphModified();
        }
    }

    public void visit(Relation relation) {
        relation.getLeft().accept((ExpressionVisitor)this);
        Expression left = this.resultExpr;
        relation.getRight().accept((ExpressionVisitor)this);
        Expression right = this.resultExpr;
        this.resultExpr = new Relation(left, right, relation.getType());
        if (this.isConstant(left) && this.isConstant(right)) {
            FloatConstant leftc = (FloatConstant)left;
            FloatConstant rightc = (FloatConstant)right;
            boolean unknown = false;
            switch (relation.getType()) {
                case GREATER: {
                    this.resultExpr = leftc.getValue() > rightc.getValue() ? new FloatConstant(1.0) : new FloatConstant(0.0);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    this.resultExpr = leftc.getValue() >= rightc.getValue() ? new FloatConstant(1.0) : new FloatConstant(0.0);
                    break;
                }
                case LESS: {
                    this.resultExpr = leftc.getValue() < rightc.getValue() ? new FloatConstant(1.0) : new FloatConstant(0.0);
                    break;
                }
                case LESS_OR_EQUAL: {
                    this.resultExpr = leftc.getValue() <= rightc.getValue() ? new FloatConstant(1.0) : new FloatConstant(0.0);
                    break;
                }
                default: {
                    System.err.println("Warning: Unknown relation type " + relation.getTypeString() + ": Relation won't be optimized.");
                    unknown = true;
                }
            }
            if (!unknown) {
                this.setGraphModified();
            }
        }
    }

    public void visit(StartNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
        node.getValue().accept((ExpressionVisitor)this);
        node.setValue(this.resultExpr);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
    }

    public void visit(EndNode node) {
    }

    public void visit(LogicalNegation node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(FunctionArgument node) {
    }

    public void visit(MacroCall node) {
        for (Expression arg : node.getArguments()) {
            arg.accept((ExpressionVisitor)this);
        }
    }

    public void visit(LoopNode node) {
        node.getBody().accept((ControlFlowVisitor)this);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(Macro node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visit(ExpressionStatement node) {
        node.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

