/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.api.dfg.DFGNodeType;
import de.gaalop.api.dfg.DFGNodeTypeGetter;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.tba.cfgImport.optimization.ConstantFolding;
import de.gaalop.tba.cfgImport.optimization.DFGVisitorUsedVariables;
import de.gaalop.tba.cfgImport.optimization.VariableComponent;
import java.util.HashMap;

public class ConstantPropagation
extends EmptyControlFlowVisitor {
    private ConstantFolding constantFolding = new ConstantFolding();
    private HashMap<VariableComponent, FloatConstant> mapConstants = new HashMap();
    private DFGVisitorUsedVariables dfgVisitorUsedVariables = new DFGVisitorUsedVariables();
    private boolean graphModified = false;

    public boolean isGraphModified() {
        return this.graphModified;
    }

    private void setGraphModified() {
        this.graphModified = true;
    }

    private Expression performConstantPropagationOnExpression(Expression expression) {
        this.dfgVisitorUsedVariables.getVariables().clear();
        expression.accept((ExpressionVisitor)this.dfgVisitorUsedVariables);
        for (VariableComponent varComp : this.dfgVisitorUsedVariables.getVariables()) {
            if (!this.mapConstants.containsKey(varComp)) continue;
            if (expression == varComp.getReferredExpression()) {
                expression = (Expression)this.mapConstants.get(varComp);
            } else {
                expression.replaceExpression(varComp.getReferredExpression(), (Expression)this.mapConstants.get(varComp));
            }
            this.setGraphModified();
        }
        expression.accept((ExpressionVisitor)this.constantFolding);
        if (this.constantFolding.isGraphModified()) {
            this.setGraphModified();
        }
        return this.constantFolding.getResultExpr();
    }

    public void visit(AssignmentNode node) {
        node.setValue(this.performConstantPropagationOnExpression(node.getValue()));
        this.dfgVisitorUsedVariables.getVariables().clear();
        node.getVariable().accept((ExpressionVisitor)this.dfgVisitorUsedVariables);
        VariableComponent target = this.dfgVisitorUsedVariables.getVariables().getFirst();
        this.mapConstants.remove(target);
        if (this.isFloatConstant(node.getValue())) {
            this.mapConstants.put(target, (FloatConstant)node.getValue());
        }
        super.visit(node);
    }

    public void visit(ColorNode node) {
        node.setR(this.performConstantPropagationOnExpression(node.getR()));
        node.setG(this.performConstantPropagationOnExpression(node.getG()));
        node.setB(this.performConstantPropagationOnExpression(node.getB()));
        node.setAlpha(this.performConstantPropagationOnExpression(node.getAlpha()));
        super.visit(node);
    }

    public void visit(ExpressionStatement node) {
        node.setExpression(this.performConstantPropagationOnExpression(node.getExpression()));
        super.visit(node);
    }

    public void visit(StoreResultNode node) {
        super.visit(node);
    }

    private boolean isFloatConstant(Expression expression) {
        return DFGNodeTypeGetter.getTypeOfDFGNode(expression) == DFGNodeType.FloatConstant;
    }
}

