/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.visitors.ReplaceVisitor;

public class ExpressionReplacer
extends ReplaceVisitor {
    private final Expression toReplace;
    private final Expression replacement;

    public ExpressionReplacer(Expression toReplace, Expression replacement) {
        this.toReplace = toReplace;
        this.replacement = replacement;
    }

    public Expression replace(Expression expression) {
        if (expression == this.toReplace) {
            return this.replacement;
        }
        return super.replace(expression);
    }

    protected void visitBinaryOperation(BinaryOperation node) {
        if (node == this.toReplace) {
            this.result = this.replacement;
            return;
        }
        if (node.getLeft() == this.toReplace) {
            node.setLeft(this.replacement);
        }
        if (node.getRight() == this.toReplace) {
            node.setRight(this.replacement);
        }
        super.visitBinaryOperation(node);
    }

    protected void visitUnaryOperation(UnaryOperation node) {
        if (node == this.toReplace) {
            this.result = this.replacement;
            return;
        }
        if (node.getOperand() == this.toReplace) {
            node.setOperand(this.replacement);
        }
        super.visitUnaryOperation(node);
    }

    protected void visitTerminal(Expression node) {
        if (node == this.toReplace) {
            this.result = this.replacement;
        }
    }
}

