/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.OptimizationException;
import de.gaalop.api.cfg.AssignmentNodeCollector;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.tba.Plugin;
import de.gaalop.tba.cfgImport.optimization.maxima.DFGToMaximaCode;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaConnection;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaInput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaOutput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaRoutines;
import de.gaalop.tba.cfgImport.optimization.maxima.StoreResultNodesCollector;
import java.util.LinkedList;
import java.util.ListIterator;

public class MaximaOptimizer {
    private MaximaConnection connection;
    private AssignmentNodeCollector assignmentNodeCollector;
    private Plugin plugin;
    private StoreResultNodesCollector collector;

    public MaximaOptimizer(MaximaConnection connection, Plugin plugin) {
        this.connection = connection;
        this.plugin = plugin;
    }

    public void transformGraph(ControlFlowGraph graph) throws OptimizationException {
        this.collector = new StoreResultNodesCollector();
        graph.accept((ControlFlowVisitor)this.collector);
        MaximaInput input = new MaximaInput();
        input.add("display2d:false;");
        input.add("ratprint:false;");
        input.add("keepfloat:true;");
        this.fillMaximaInput(graph, input);
        input.add("quit();");
        MaximaOutput output = this.connection.optimizeWithMaxima(input);
        LinkedList<String> connected = new LinkedList<String>();
        MaximaRoutines.groupMaximaInAndOutputs(connected, output);
        connected.removeFirst();
        connected.removeFirst();
        connected.removeFirst();
        ListIterator listIterator = this.assignmentNodeCollector.getAssignmentNodes().listIterator();
        for (String io : connected) {
            Expression exp = MaximaRoutines.getExpressionFromMaximaOutput(io);
            ((AssignmentNode)listIterator.next()).setValue(exp);
        }
    }

    private void fillMaximaInput(ControlFlowGraph graph, MaximaInput input) {
        this.assignmentNodeCollector = new AssignmentNodeCollector();
        graph.accept((ControlFlowVisitor)this.assignmentNodeCollector);
        for (AssignmentNode node : this.assignmentNodeCollector.getAssignmentNodes()) {
            DFGToMaximaCode dfg = new DFGToMaximaCode();
            node.getVariable().accept((ExpressionVisitor)dfg);
            String variable = "";
            dfg = new DFGToMaximaCode();
            node.getValue().accept((ExpressionVisitor)dfg);
            String value = "ratsimp(" + dfg.getResultString() + ");";
            if (this.plugin.isOptInserting()) {
                String name = node.getVariable().getName();
                if (!graph.getPragmaOnlyEvaluateVariables().contains(name) && !this.collector.containsStoreResultVariableName(name)) {
                    dfg = new DFGToMaximaCode();
                    node.getVariable().accept((ExpressionVisitor)dfg);
                    variable = dfg.getResultString() + "::";
                }
            }
            if (!this.plugin.isScalarFunctions() & !(node.getVariable() instanceof MultivectorComponent)) {
                variable = "";
            }
            if (this.plugin.isMaximaExpand()) {
                input.add(variable + "expand(ratsimp(" + value.substring(0, value.length() - 1) + "));");
                continue;
            }
            input.add(variable + value);
        }
    }
}

