/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization.maxima;

import de.gaalop.OptimizationException;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaConnection;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaInput;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessBuilderMaximaConnection
implements MaximaConnection {
    public String commandMaxima;
    public static final String CMD_MAXIMA_WINDOWS = "C:\\Program Files (x86)\\Maxima-5.24.0\\bin\\maxima.bat";
    public static final String CMD_MAXIMA_LINUX = "/usr/bin/maxima";

    public ProcessBuilderMaximaConnection(String commandMaxima) {
        this.commandMaxima = commandMaxima;
    }

    @Override
    public MaximaOutput optimizeWithMaxima(MaximaInput input) throws OptimizationException {
        try {
            String line;
            Process p;
            File tmpFile = File.createTempFile("tbaMaxima", ".txt");
            PrintWriter out = new PrintWriter(tmpFile);
            for (String line2 : input) {
                out.println(line2);
            }
            out.close();
            MaximaOutput output = new MaximaOutput();
            String path = tmpFile.getAbsolutePath();
            if (File.separatorChar == '\\') {
                path = path.replaceAll("\\\\", "\\\\\\\\");
            }
            try {
                ProcessBuilder builder = new ProcessBuilder(this.commandMaxima, "-b", path);
                p = builder.start();
            }
            catch (Exception e) {
                tmpFile.delete();
                throw new OptimizationException("Maxima is not accessible. Please check the Maxima command in the Configurations panel or disable the usage of Maxima.", null);
            }
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = b.readLine()) != null) {
                output.add(line);
            }
            b.close();
            tmpFile.delete();
            return output;
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessBuilderMaximaConnection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

