/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table;

import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.productComputer.GeoProductCalculator;
import de.gaalop.productComputer.InnerProductCalculator;
import de.gaalop.productComputer.OuterProductCalculator;
import de.gaalop.tba.BladeRef;
import de.gaalop.tba.IMultTable;
import de.gaalop.tba.MultTableAbsDirectComputer;
import de.gaalop.tba.MultTableImpl;
import de.gaalop.tba.Multivector;
import de.gaalop.tba.table.TableFormat;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFileChooser;

public class Main {
    private static void createFromDir(File dir, int format) throws FileNotFoundException, IOException {
        File definitionFile;
        System.out.print(dir.getName() + ":");
        if (!dir.exists()) {
            System.out.println("The given first parameter, is not the path of an existing directory!");
            System.exit(2);
        }
        if (!(definitionFile = new File(dir, "definition.csv")).exists()) {
            System.out.println("There is no file named 'definition.csv' in the directory!");
            System.exit(3);
        }
        AlgebraDefinitionFile alFile = new AlgebraDefinitionFile();
        FileInputStream inputStream = new FileInputStream(definitionFile);
        alFile.loadFromFile((InputStream)inputStream);
        inputStream.close();
        MultTableAbsDirectComputer inner = new MultTableAbsDirectComputer(alFile, new InnerProductCalculator());
        MultTableAbsDirectComputer outer = new MultTableAbsDirectComputer(alFile, new OuterProductCalculator());
        MultTableAbsDirectComputer geo = new MultTableAbsDirectComputer(alFile, new GeoProductCalculator());
        int dimension = alFile.base.length - 1;
        TableFormat.writeToFile((int)Math.pow(2.0, dimension), dimension, inner, outer, geo, new FileOutputStream(new File(dir, "products.csv")), format);
        System.out.println("Verify created file");
        int bladeCount = (int)Math.pow(2.0, dimension);
        MultTableImpl innerStored = new MultTableImpl();
        innerStored.createTable(bladeCount);
        MultTableImpl outerStored = new MultTableImpl();
        outerStored.createTable(bladeCount);
        MultTableImpl geoStored = new MultTableImpl();
        geoStored.createTable(bladeCount);
        TableFormat.readFromFile(new FileInputStream(new File(dir, "products.csv")), innerStored, outerStored, geoStored);
        Main.testEqual(innerStored, inner, dimension);
        Main.testEqual(outerStored, outer, dimension);
        Main.testEqual(geoStored, geo, dimension);
    }

    private static void gui(String[] args) throws FileNotFoundException, IOException {
        File dir = null;
        if (args.length == 0) {
            JFileChooser jFC = new JFileChooser("D:\\BscMsc\\Gaalop\\algebra\\src\\main\\resources\\de\\gaalop\\algebra\\algebra");
            jFC.setFileSelectionMode(1);
            if (jFC.showOpenDialog(null) == 0) {
                dir = jFC.getSelectedFile();
                System.out.println(dir.getCanonicalPath());
            } else {
                System.out.println("No directory chosen!");
                System.exit(1);
            }
        } else {
            dir = new File(args[0]);
        }
    }

    private static void createAll() throws FileNotFoundException, IOException {
        File directory = new File("D:\\BscMsc\\Gaalop\\algebra\\src\\main\\resources\\de\\gaalop\\algebra\\algebra");
        Object[] dirs = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            Main.createFromDir((File)dir, 1);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Main.createAll();
    }

    private static void testEqual(IMultTable t1, IMultTable t2, int dimension) {
        int bladeCount = (int)Math.pow(2.0, dimension);
        for (int i1 = 0; i1 < bladeCount; ++i1) {
            for (int i2 = 0; i2 < bladeCount; ++i2) {
                if (Main.testEqual(t1.getProduct(i1, i2), t2.getProduct(i1, i2))) continue;
                System.out.print(i1 + "!=" + i2 + ": " + t1.getProduct(i1, i2).print() + " != " + t2.getProduct(i1, i2).print());
            }
        }
    }

    private static boolean testEqual(Multivector m1, Multivector m2) {
        Vector<BladeRef> v1 = new Vector<BladeRef>(m1.getBlades());
        Vector<BladeRef> v2 = new Vector<BladeRef>(m2.getBlades());
        if (v1.size() != v2.size()) {
            return false;
        }
        for (BladeRef b2 : v2) {
            if (!v1.contains(b2)) continue;
            v1.remove(b2);
        }
        return v1.isEmpty();
    }
}

