/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.table;

import de.gaalop.tba.BladeRef;
import de.gaalop.tba.IMultTable;
import de.gaalop.tba.Multivector;
import de.gaalop.tba.table.BitIO.AbsBitReader;
import de.gaalop.tba.table.BitIO.AbsBitWriter;
import de.gaalop.tba.table.BitIO.SimpleBitReader;
import de.gaalop.tba.table.BitIO.SimpleBitWriter;
import de.gaalop.tba.table.TableReaderIO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableCompressed
implements TableReaderIO {
    private AbsBitReader reader;
    private AbsBitWriter writer;

    public TableCompressed(AbsBitReader reader, AbsBitWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public void readFromInputStream(DataInputStream in, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable) {
        try {
            byte dimension = in.readByte();
            int bladeCount = (int)Math.pow(2.0, dimension);
            byte bitCount = in.readByte();
            this.reader.setDataInputStream(in);
            for (int i = 0; i < bladeCount; ++i) {
                for (int j = 0; j < bladeCount; ++j) {
                    innerTable.setProduct(i, j, this.readMultivector(this.reader, dimension, bitCount));
                    outerTable.setProduct(i, j, this.readMultivector(this.reader, dimension, bitCount));
                    geoTable.setProduct(i, j, this.readMultivector(this.reader, dimension, bitCount));
                }
            }
            in.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TableCompressed.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Multivector readMultivector(AbsBitReader in, int dimension, int bitCount) throws IOException {
        Multivector result = new Multivector();
        int size = in.read(bitCount);
        for (int i = 0; i < size; ++i) {
            int prefactor = in.read(1);
            int index = in.read(dimension);
            result.addBlade(new BladeRef(prefactor == 1 ? (byte)-1 : 1, index));
        }
        return result;
    }

    private void writeMultivector(Multivector product, int dimension, AbsBitWriter out, int bitCount) throws IOException {
        int size = product.getBlades().size();
        out.write(size, bitCount);
        for (BladeRef bR : product.getBlades()) {
            out.write(bR.getPrefactor() < 0 ? 1 : 0, 1);
            out.write(bR.getIndex(), dimension);
        }
    }

    @Override
    public void writeFromInputStream(int bladeCount, int dimension, IMultTable innerTable, IMultTable outerTable, IMultTable geoTable, DataOutputStream out) {
        try {
            SimpleBitWriter w = new SimpleBitWriter();
            int bitCount = 32;
            File tempFile = File.createTempFile("TableCreator", "txt");
            DataOutputStream out1 = new DataOutputStream(new FileOutputStream(tempFile));
            w.setDataOutputStream(out1);
            int maxNumber = 0;
            for (int i = 0; i < bladeCount; ++i) {
                for (int j = 0; j < bladeCount; ++j) {
                    Multivector innerM = innerTable.getProduct(i, j);
                    Multivector outerM = outerTable.getProduct(i, j);
                    Multivector geoM = geoTable.getProduct(i, j);
                    maxNumber = Math.max(maxNumber, innerM.getBlades().size());
                    maxNumber = Math.max(maxNumber, outerM.getBlades().size());
                    maxNumber = Math.max(maxNumber, geoM.getBlades().size());
                    this.writeMultivector(innerM, dimension, w, bitCount);
                    this.writeMultivector(outerM, dimension, w, bitCount);
                    this.writeMultivector(geoM, dimension, w, bitCount);
                }
            }
            w.finish();
            out1.close();
            DataInputStream in = new DataInputStream(new FileInputStream(tempFile));
            SimpleBitReader r = new SimpleBitReader();
            r.setDataInputStream(in);
            int bitCount2 = 1;
            for (int number = 2; number < maxNumber + 1; number *= 2) {
                ++bitCount2;
            }
            out.writeByte(dimension);
            out.writeByte(bitCount2);
            this.writer.setDataOutputStream(out);
            for (int i = 0; i < bladeCount; ++i) {
                for (int j = 0; j < bladeCount; ++j) {
                    this.writeMultivector(this.readMultivector(r, dimension, bitCount), dimension, this.writer, bitCount2);
                    this.writeMultivector(this.readMultivector(r, dimension, bitCount), dimension, this.writer, bitCount2);
                    this.writeMultivector(this.readMultivector(r, dimension, bitCount), dimension, this.writer, bitCount2);
                }
            }
            this.writer.finish();
            in.close();
            tempFile.delete();
        }
        catch (IOException ex) {
            Logger.getLogger(TableCompressed.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public AbsBitReader getReader() {
        return this.reader;
    }
}

