/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualCodeInserter2d;

import de.gaalop.OptimizationException;
import de.gaalop.VisualCodeInserterStrategy;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Variable;
import de.gaalop.visualCodeInserter2d.ExpressionStatementCollector;
import java.util.HashMap;
import java.util.LinkedList;

public class VisualizerCodeInserter2d
implements VisualCodeInserterStrategy {
    public void transform(ControlFlowGraph graph) throws OptimizationException {
        LinkedList<ExpressionStatement> statements = ExpressionStatementCollector.collectAllStatements(graph);
        String prefix = "_V_";
        HashMap renderingExpressions = graph.getRenderingExpressions();
        int i = 0;
        for (ExpressionStatement s : statements) {
            String productName = prefix + "PRODUCT" + i;
            AssignmentNode renderNode = new AssignmentNode(graph, new Variable(productName), s.getExpression());
            graph.addLocalVariable(new Variable(productName));
            s.insertAfter((SequentialNode)renderNode);
            StoreResultNode outputRenderNode = new StoreResultNode(graph, new Variable(productName));
            graph.addLocalVariable(new Variable(productName));
            renderNode.insertAfter((SequentialNode)outputRenderNode);
            renderingExpressions.put(productName, s.getExpression());
            ++i;
        }
    }
}

