/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.julia;

import de.gaalop.DefaultCodeGeneratorVisitor;
import de.gaalop.StringList;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.OutputsCollector;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Variable;

public class JuliaVisitor
extends DefaultCodeGeneratorVisitor {
    private boolean forGrassmann;

    public JuliaVisitor(boolean forGrassmann) {
        this.forGrassmann = forGrassmann;
    }

    private void not_implemented(String nodeType) {
        throw new UnsupportedOperationException("The Julia backend does not support \"" + nodeType + "\"!");
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        int bladeCount = this.graph.getAlgebraDefinitionFile().getBladeCount();
        StringList locals = this.graph.getLocals();
        if (this.forGrassmann) {
            this.code.append("# using StaticArrays, Grassmann\n\n");
        }
        this.code.append("function " + this.graph.getSource().getName().split("\\.")[0] + "(");
        StringList inputs = this.graph.getInputs();
        if (this.forGrassmann) {
            inputs.addFirst((Object)"V");
        }
        this.code.append(inputs.join());
        this.code.append(")\n");
        for (String var : locals) {
            this.code.append('\t');
            this.code.append(var);
            this.code.append(" = ");
            if (this.forGrassmann) {
                this.code.append("@MArray ");
            }
            this.code.append("zeros(");
            this.code.append(bladeCount);
            this.code.append(")\n");
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        this.code.append("\t");
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";");
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.append(" # ");
            this.code.append(this.graph.getBladeString((MultivectorComponent)node.getVariable()));
        }
        this.code.append("\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.not_implemented("ExpressionStatement");
    }

    public void visit(EndNode node) {
        this.code.append('\t');
        StringList results = OutputsCollector.getOutputsFromGraphAsSortedList((ControlFlowGraph)this.graph);
        StringList list = new StringList();
        for (String var : results) {
            if (this.forGrassmann) {
                list.add((Object)("MultiVector{V}(" + var + ")"));
                continue;
            }
            list.add((Object)var);
        }
        this.code.append(list.join() + "\n");
        this.code.append("end\n");
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MathFunctionCall node) {
        String functionName = "";
        switch (node.getFunction()) {
            case SQRT: {
                functionName = "sqrt";
                break;
            }
            case ABS: {
                functionName = "abs";
                break;
            }
            case COS: {
                functionName = "cos";
                break;
            }
            case SIN: {
                functionName = "sin";
                break;
            }
            case EXP: {
                functionName = "exp";
                break;
            }
            default: {
                this.not_implemented("specific MathFunctionCall");
            }
        }
        this.code.append(functionName);
        this.code.append("(");
        node.getOperand().accept((ExpressionVisitor)this);
        this.code.append(")");
    }

    public void visit(Variable node) {
        this.code.append(node.getName());
    }

    public void visit(MultivectorComponent node) {
        this.code.append(node.getName());
        this.code.append("[");
        this.code.append(node.getBladeIndex() + 1);
        this.code.append("]");
    }

    public void visit(Exponentiation node) {
        this.code.append("(");
        node.getLeft().accept((ExpressionVisitor)this);
        this.code.append(") ^ (");
        node.getRight().accept((ExpressionVisitor)this);
        this.code.append(")");
    }

    public void visit(FloatConstant node) {
        this.code.append(Double.toString(node.getValue()));
        this.code.append("f0");
    }

    public void visit(Negation node) {
        this.code.append("(-");
        node.getOperand().accept((ExpressionVisitor)this);
        this.code.append(")");
    }
}

