/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.julia;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.julia.JuliaCodeGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
implements CodeGeneratorPlugin {
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean forGrassmann;

    public void setForGrassmann(boolean forGrassmann) {
        this.forGrassmann = forGrassmann;
    }

    public boolean getForGrassmann() {
        return this.forGrassmann;
    }

    public Plugin() {
        URL url = this.getClass().getResource("icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find plugin icon!");
        }
    }

    public CodeGenerator createCodeGenerator() {
        return new JuliaCodeGenerator(this.getForGrassmann());
    }

    public String getName() {
        return "Julia";
    }

    public String getDescription() {
        return "This plugin generates Julia code.";
    }

    public Image getIcon() {
        return this.icon;
    }
}

