/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.CodeParserPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.Plugin;
import de.gaalop.Plugins;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import de.gaalop.gui.FontSize;
import de.gaalop.gui.PluginSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.beanutils.BeanUtils;

public class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 7710406876645754914L;
    private JTabbedPane pluginPanes = new JTabbedPane();

    public ConfigurationPanel(JTabbedPane tabbedPanel) {
        tabbedPanel.addTab("Configuration", this);
        int indexOfPanel = tabbedPanel.indexOfComponent(this);
        tabbedPanel.setSelectedIndex(indexOfPanel);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pluginPanes, "Center");
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        this.pluginPanes.setFont(font);
        for (CodeParserPlugin parser : Plugins.getCodeParserPlugins()) {
            this.addPluginConfig((Plugin)parser);
        }
        for (GlobalSettingsStrategyPlugin global : Plugins.getGlobalSettingsStrategyPlugins()) {
            this.addPluginConfig((Plugin)global);
        }
        for (VisualCodeInserterStrategyPlugin visStrat : Plugins.getVisualizerStrategyPlugins()) {
            this.addPluginConfig((Plugin)visStrat);
        }
        for (AlgebraStrategyPlugin algebra : Plugins.getAlgebraStrategyPlugins()) {
            this.addPluginConfig((Plugin)algebra);
        }
        for (OptimizationStrategyPlugin strategy : Plugins.getOptimizationStrategyPlugins()) {
            this.addPluginConfig((Plugin)strategy);
        }
        ArrayList sortedPlugins = new ArrayList(Plugins.getCodeGeneratorPlugins());
        Collections.sort(sortedPlugins, new PluginSorter());
        for (CodeGeneratorPlugin generator : sortedPlugins) {
            this.addPluginConfig((Plugin)generator);
        }
        this.pluginPanes.setSelectedIndex(0);
    }

    private void addPluginConfig(final Plugin plugin) {
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BorderLayout());
        List<Field> properties = this.getConfigurationProperties(plugin);
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(properties.size(), 1));
        JPanel fields = new JPanel();
        fields.setLayout(new GridLayout(properties.size(), 1));
        configPanel.add((Component)labels, "West");
        configPanel.add((Component)fields, "Center");
        for (final Field property : properties) {
            JLabel label = new JLabel(property.getName());
            label.setFont(font);
            labels.add(label);
            try {
                String value = BeanUtils.getProperty((Object)plugin, (String)property.getName());
                ConfigurationProperty clazz = property.getAnnotation(ConfigurationProperty.class);
                switch (clazz.type()) {
                    case BOOLEAN: {
                        final JCheckBox checkBox = new JCheckBox();
                        checkBox.setFont(font);
                        checkBox.setSelected(Boolean.parseBoolean(value));
                        checkBox.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)checkBox.isSelected());
                                }
                                catch (IllegalAccessException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        fields.add(checkBox);
                        break;
                    }
                    case NUMBER: {
                        final JTextField numberField = new JTextField(value);
                        numberField.setFont(font);
                        numberField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                int intVal = numberField.getText().length() > 0 ? Integer.parseInt(numberField.getText()) : 0;
                                try {
                                    BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)intVal);
                                }
                                catch (IllegalAccessException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        fields.add(numberField);
                        break;
                    }
                    case DIRPATH: {
                        final JTextField textField3 = new JTextField(value);
                        textField3.setFont(font);
                        textField3.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                try {
                                    BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)textField3.getText());
                                }
                                catch (IllegalAccessException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        JPanel subPanel2 = new JPanel(new GridLayout(1, 3, 5, 5));
                        subPanel2.add(textField3);
                        fields.add(subPanel2);
                        JButton button3 = new JButton("Choose directory path");
                        subPanel2.add(button3);
                        button3.setFont(font);
                        button3.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JFileChooser jFC = new JFileChooser();
                                jFC.setCurrentDirectory(new File(textField3.getText()));
                                jFC.setSelectedFile(new File(textField3.getText()));
                                jFC.setFileSelectionMode(1);
                                if (jFC.showOpenDialog(null) == 0) {
                                    textField3.setText(jFC.getSelectedFile().getAbsolutePath());
                                    try {
                                        BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)textField3.getText());
                                    }
                                    catch (IllegalAccessException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (InvocationTargetException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case FILEPATH: {
                        final JTextField textField2 = new JTextField(value);
                        textField2.setFont(font);
                        textField2.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                try {
                                    BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)textField2.getText());
                                }
                                catch (IllegalAccessException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        JPanel subPanel = new JPanel(new GridLayout(1, 3, 5, 5));
                        subPanel.add(textField2);
                        fields.add(subPanel);
                        JButton button = new JButton("Choose file path");
                        subPanel.add(button);
                        button.setFont(font);
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JFileChooser jFC = new JFileChooser();
                                jFC.setCurrentDirectory(new File(textField2.getText()));
                                jFC.setSelectedFile(new File(textField2.getText()));
                                if (jFC.showOpenDialog(null) == 0) {
                                    textField2.setText(jFC.getSelectedFile().getAbsolutePath());
                                    try {
                                        BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)textField2.getText());
                                    }
                                    catch (IllegalAccessException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (InvocationTargetException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        final JTextField textField = new JTextField(value);
                        textField.setFont(font);
                        textField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                try {
                                    BeanUtils.setProperty((Object)plugin, (String)property.getName(), (Object)textField.getText());
                                }
                                catch (IllegalAccessException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        fields.add(textField);
                        break;
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)configPanel, "North");
        panel.add((Component)new JPanel(), "Center");
        if (!properties.isEmpty()) {
            this.pluginPanes.add(plugin.getName(), panel);
        }
    }

    private List<Field> getConfigurationProperties(Plugin plugin) {
        ArrayList<Field> configProperties = new ArrayList<Field>();
        for (Field field : plugin.getClass().getFields()) {
            if (!field.isAnnotationPresent(ConfigurationProperty.class)) continue;
            configProperties.add(field);
        }
        return configProperties;
    }
}

