/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilationException;
import de.gaalop.Plugins;
import de.gaalop.gui.CloseAction;
import de.gaalop.gui.CompileAction;
import de.gaalop.gui.ConfigurationPanel;
import de.gaalop.gui.ErrorDialog;
import de.gaalop.gui.FileState;
import de.gaalop.gui.FontSize;
import de.gaalop.gui.GaalopLogoFiller;
import de.gaalop.gui.Main;
import de.gaalop.gui.NewFileAction;
import de.gaalop.gui.OpenFileAction;
import de.gaalop.gui.PanelPluginSelection;
import de.gaalop.gui.PluginSorter;
import de.gaalop.gui.SourceFilePanel;
import de.gaalop.gui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainForm {
    private JPanel contentPane;
    private JButton optimizeButton;
    private JButton configureButton;
    private JLabel logoIcon;
    private JTabbedPane tabbedPane;
    private JEditorPane welcomeToGaalopWelcomeEditorPane;
    private JButton newFileButton;
    private JButton openFileButton;
    private JButton saveFileButton;
    private JButton closeButton;
    private StatusBar statusBar;
    private final String ScriptFileExtension = "clu";
    public PanelPluginSelection panelPluginSelection;
    private Log log = LogFactory.getLog(MainForm.class);
    private Boolean optimizeOnFileChanged = true;
    Set<String> watchedFilePaths = new HashSet<String>();
    long lastOptimizationTimeMillis = System.currentTimeMillis();

    public MainForm() {
        this.$$$setupUI$$$();
        this.optimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainForm.this.Optimize();
            }
        });
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ConfigurationPanel(MainForm.this.tabbedPane);
            }
        });
        this.newFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList plugins = new ArrayList();
                plugins.addAll(Plugins.getCodeParserPlugins());
                Collections.sort(plugins, new PluginSorter());
                if (plugins.size() == 1) {
                    NewFileAction action = new NewFileAction((CodeParserPlugin)plugins.get(0), MainForm.this.tabbedPane);
                    action.actionPerformed(null);
                } else {
                    JPopupMenu menu = new JPopupMenu("New File");
                    for (CodeParserPlugin plugin : plugins) {
                        menu.add(new NewFileAction(plugin, MainForm.this.tabbedPane));
                    }
                    menu.show(MainForm.this.newFileButton, 0, ((MainForm)MainForm.this).newFileButton.getBounds().height);
                }
            }
        });
        this.saveFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.Save(false);
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MainForm.this.tabbedPane.getSelectedComponent() instanceof SourceFilePanel) {
                    MainForm.this.saveFileButton.setEnabled(true);
                    MainForm.this.optimizeButton.setEnabled(true);
                    MainForm.this.closeButton.setEnabled(true);
                } else if (MainForm.this.tabbedPane.getSelectedComponent() instanceof ConfigurationPanel) {
                    MainForm.this.saveFileButton.setEnabled(false);
                    MainForm.this.optimizeButton.setEnabled(false);
                    MainForm.this.closeButton.setEnabled(true);
                } else {
                    MainForm.this.saveFileButton.setEnabled(false);
                    MainForm.this.optimizeButton.setEnabled(false);
                    MainForm.this.closeButton.setEnabled(false);
                }
            }
        });
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList plugins = new ArrayList();
                plugins.addAll(Plugins.getCodeParserPlugins());
                Collections.sort(plugins, new PluginSorter());
                if (plugins.size() == 1) {
                    OpenFileAction action = new OpenFileAction((CodeParserPlugin)plugins.get(0), MainForm.this.tabbedPane);
                    action.actionPerformed(null);
                } else {
                    JPopupMenu menu = new JPopupMenu("Open File");
                    for (CodeParserPlugin plugin : plugins) {
                        menu.add(new OpenFileAction(plugin, MainForm.this.tabbedPane));
                    }
                    menu.show(MainForm.this.openFileButton, 0, ((MainForm)MainForm.this).openFileButton.getBounds().height);
                }
            }
        });
        this.closeButton.setAction(new CloseAction(this.tabbedPane));
        this.welcomeToGaalopWelcomeEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL u = e.getURL();
                    try {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                    catch (IOException e1) {
                        MainForm.this.log.error((Object)e1);
                    }
                    catch (URISyntaxException e1) {
                        MainForm.this.log.error((Object)e1);
                    }
                }
            }
        });
        try {
            this.welcomeToGaalopWelcomeEditorPane.read(this.getClass().getResourceAsStream("welcome.html"), (Object)null);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to read welcome document.");
        }
    }

    private String GetFilePath() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof SourceFilePanel) {
            SourceFilePanel filePanel = (SourceFilePanel)component;
            File file = filePanel.getFile();
            String path = file.getAbsolutePath();
            return path;
        }
        return "";
    }

    public static String readFile(String filePath) throws IOException {
        byte[] encodedBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
        return new String(encodedBytes);
    }

    private void Save(Boolean allowQuickSave) {
        this.optimizeOnFileChanged = false;
        System.out.println("optimizeOnFileChanged = " + this.optimizeOnFileChanged);
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof SourceFilePanel) {
            SourceFilePanel filePanel = (SourceFilePanel)component;
            File file = filePanel.getFile();
            String path = file.getAbsolutePath();
            if (!this.watchedFilePaths.contains(path)) {
                this.watchedFilePaths.add(path);
                this.createActionOnFileChange(path, filePanel);
            }
            if (allowQuickSave.booleanValue() && path.endsWith("clu")) {
                this.statusBar.setStatus("Saved source: " + path);
                this.saveToFile(file, filePanel);
            } else {
                Main.lastDirectory = file.getParentFile();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(Main.lastDirectory);
                fileChooser.setSelectedFile(file);
                fileChooser.setFileFilter(new FileNameExtensionFilter("CLUcalc files", "clu"));
                int result = fileChooser.showSaveDialog(this.contentPane);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    String filePath = selectedFile.getAbsolutePath();
                    if (!filePath.toLowerCase().endsWith(".clu")) {
                        selectedFile = new File(filePath + "." + "clu");
                    }
                    this.saveToFile(selectedFile, filePanel);
                }
            }
        }
        this.optimizeOnFileChanged = true;
        System.out.println("optimizeOnFileChanged = " + this.optimizeOnFileChanged);
    }

    private void Optimize() {
        if (this.tabbedPane.getSelectedComponent() instanceof SourceFilePanel) {
            if (this.panelPluginSelection.areConstraintsFulfilled()) {
                this.panelPluginSelection.updateLastUsedPlugins();
                SourceFilePanel sourcePanel = (SourceFilePanel)this.tabbedPane.getSelectedComponent();
                CompileAction action = new CompileAction(sourcePanel, this.statusBar, this.panelPluginSelection);
                action.actionPerformed(null);
                this.lastOptimizationTimeMillis = System.currentTimeMillis();
            } else {
                ErrorDialog.show(new CompilationException(this.panelPluginSelection.getErrorMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File toFile, SourceFilePanel sourceFilePanel) {
        try {
            try (PrintWriter printWriter = new PrintWriter(toFile);){
                printWriter.print(sourceFilePanel.getInputFile().getContent());
            }
            sourceFilePanel.setFile(toFile);
            sourceFilePanel.setSaved();
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)e);
            JOptionPane.showMessageDialog(this.contentPane, "Unable to save to " + toFile.getAbsolutePath() + "\n" + e, "Error", 0);
        }
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void loadOpenedFiles() {
        Preferences prefs = Preferences.userNodeForPackage(MainForm.class);
        int count = prefs.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            String filename = prefs.get("file" + i, "");
            String pluginClass = prefs.get("plugin" + i, "");
            if (filename.isEmpty()) continue;
            File file = new File(filename);
            CodeParserPlugin plugin = this.getParserPluginByName(pluginClass);
            if (plugin != null) {
                String content = this.getContentOfFile(filename);
                if (content == null) continue;
                SourceFilePanel panel = new SourceFilePanel(plugin, file, content);
                this.tabbedPane.add(panel);
                this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(panel), panel.getTabLabel());
                continue;
            }
            this.log.warn((Object)("Code Parser Plugin of MRU file not found: " + pluginClass + " file: " + filename));
        }
    }

    private String getContentOfFile(String filename) {
        try {
            String line;
            FileReader fileReader = new FileReader(filename);
            BufferedReader reader = new BufferedReader(fileReader);
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            return result.toString();
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to open MRU file " + filename), (Throwable)e);
            return null;
        }
    }

    private CodeParserPlugin getParserPluginByName(String pluginClass) {
        for (CodeParserPlugin plugin : Plugins.getCodeParserPlugins()) {
            if (!plugin.getClass().getName().equals(pluginClass)) continue;
            return plugin;
        }
        return null;
    }

    public void saveOpenedFiles() {
        ArrayList<SourceFilePanel> panels = new ArrayList<SourceFilePanel>(this.tabbedPane.getTabCount());
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component component = this.tabbedPane.getComponentAt(i);
            if (!(component instanceof SourceFilePanel)) continue;
            panels.add((SourceFilePanel)component);
        }
        Preferences prefs = Preferences.userNodeForPackage(MainForm.class);
        try {
            prefs.clear();
            int count = 0;
            for (SourceFilePanel panel : panels) {
                if (panel.getFileState() == FileState.UNSAVED) continue;
                File file = panel.getFile();
                prefs.put("file" + count, file.getAbsolutePath());
                CodeParserPlugin plugin = panel.getParserPlugin();
                prefs.put("plugin" + count, plugin.getClass().getName());
                ++count;
            }
            prefs.putInt("count", count);
        }
        catch (BackingStoreException e) {
            this.log.warn((Object)"Unable to save opened files.", (Throwable)e);
        }
    }

    private void $$$setupUI$$$() {
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "North");
        this.logoIcon = new JLabel();
        this.logoIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/logo.png")));
        this.logoIcon.setPreferredSize(new Dimension(660, 75));
        this.logoIcon.setText("");
        panel1.add((Component)this.logoIcon, "West");
        GaalopLogoFiller gaalopLogoFiller1 = new GaalopLogoFiller();
        panel1.add((Component)gaalopLogoFiller1, "Center");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(true);
        toolBar1.setFloatable(false);
        panel1.add((Component)toolBar1, "South");
        this.newFileButton = new JButton();
        this.newFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-new.png")));
        this.newFileButton.setText("New File");
        this.newFileButton.setMnemonic('N');
        this.newFileButton.setFont(font);
        this.newFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.newFileButton);
        this.openFileButton = new JButton();
        this.openFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-open.png")));
        this.openFileButton.setText("Open File");
        this.openFileButton.setFont(font);
        this.openFileButton.setMnemonic('O');
        this.openFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.openFileButton);
        this.saveFileButton = new JButton();
        this.saveFileButton.setEnabled(false);
        this.saveFileButton.setFont(font);
        this.saveFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-save.png")));
        this.saveFileButton.setText("Save File");
        this.saveFileButton.setMnemonic('S');
        this.saveFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.saveFileButton);
        this.closeButton = new JButton();
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/emblem-unreadable.png")));
        this.closeButton.setFont(font);
        this.closeButton.setText("Close File");
        toolBar1.add(this.closeButton);
        JToolBar.Separator toolBar$Separator2 = new JToolBar.Separator();
        toolBar1.add(toolBar$Separator2);
        this.configureButton = new JButton();
        this.configureButton.setFont(font);
        this.configureButton.setEnabled(true);
        this.configureButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/preferences-system.png")));
        this.configureButton.setText("Configure");
        this.configureButton.setMnemonic('C');
        this.configureButton.setDisplayedMnemonicIndex(3);
        toolBar1.add(this.configureButton);
        JToolBar.Separator toolBar$Separator1 = new JToolBar.Separator();
        toolBar1.add(toolBar$Separator1);
        this.optimizeButton = new JButton();
        this.optimizeButton.setEnabled(false);
        this.optimizeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/applications-system.png")));
        this.optimizeButton.setText("Optimize");
        this.optimizeButton.setFont(font);
        this.optimizeButton.setMnemonic('I');
        this.optimizeButton.setDisplayedMnemonicIndex(3);
        toolBar1.add(this.optimizeButton);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(font);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.panelPluginSelection = new PanelPluginSelection();
        this.contentPane.add((Component)this.panelPluginSelection, "East");
        this.welcomeToGaalopWelcomeEditorPane = new JEditorPane();
        this.welcomeToGaalopWelcomeEditorPane.setContentType("text/html");
        this.welcomeToGaalopWelcomeEditorPane.setFont(font);
        this.welcomeToGaalopWelcomeEditorPane.setEditable(false);
        this.welcomeToGaalopWelcomeEditorPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n  </body>\r\n</html>\r\n");
        this.statusBar = new StatusBar();
        this.contentPane.add((Component)this.statusBar, "South");
        AbstractAction actionOnCtrlS = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.Save(true);
                MainForm.this.Optimize();
            }
        };
        this.contentPane.getInputMap(2).put(KeyStroke.getKeyStroke("control S"), "saveAction");
        this.contentPane.getActionMap().put("saveAction", actionOnCtrlS);
    }

    public void SaveAndOptimize() {
        this.Save(true);
    }

    public void createActionOnFileChange(String filePath, SourceFilePanel filePanel) {
        System.out.println("Created file change listener: " + filePath);
        Thread thread = new Thread(() -> {
            try {
                WatchKey key;
                boolean valid;
                WatchService watchService = FileSystems.getDefault().newWatchService();
                Path path = Paths.get(filePath, new String[0]).getParent();
                path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                block8: do {
                    try {
                        key = watchService.take();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        long passedMillis = System.currentTimeMillis() - this.lastOptimizationTimeMillis;
                        Boolean enoughTimePassed = passedMillis > 500L;
                        if (this.optimizeOnFileChanged.booleanValue() && enoughTimePassed.booleanValue()) {
                            if (!filename.toString().equals(Paths.get(filePath, new String[0]).getFileName().toString())) continue;
                            System.out.println("Optimizing because file has been changed: " + filePath);
                            try {
                                String content = MainForm.readFile(filePath);
                                if (content.isEmpty()) {
                                    try {
                                        Thread.sleep(50L);
                                        content = MainForm.readFile(filePath);
                                    }
                                    catch (Exception e) {
                                        System.out.println("Sleeping or reading failed.");
                                    }
                                    if (content.isEmpty()) {
                                        System.out.println("Content of file is empty: " + filePath);
                                        continue block8;
                                    }
                                }
                                filePanel.setContent(content);
                                this.Optimize();
                            }
                            catch (IOException e) {
                                System.out.println("Could not execute optimize.");
                            }
                            continue;
                        }
                        System.out.println("SKIPPING. optimizeOnFileChanged = " + this.optimizeOnFileChanged + ", enoughTimePassed = " + enoughTimePassed + "(" + passedMillis + ")");
                    }
                } while (valid = key.reset());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

