/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.Plugin;
import de.gaalop.Plugins;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import de.gaalop.algebra.DefinedAlgebra;
import de.gaalop.gui.AlgebraChooserItem;
import de.gaalop.gui.FontSize;
import de.gaalop.gui.PluginSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.beanutils.BeanUtils;

public class PanelPluginSelection
extends JPanel {
    private JComboBox globalSettings;
    private JComboBox visualCodeInserter;
    private JComboBox algebra;
    private JComboBox optimization;
    private JComboBox generator;
    private String errorMessage;
    private String errorPlugin1;
    private String errorPlugin2;
    private Color defaultColor;
    private JTextArea errorTextArea = new JTextArea();
    private JComboBox algebraChooser = new JComboBox();
    public static String lastUsedAlgebra;
    public static boolean lastUsedAlgebraRessource;
    public static String lastUsedGenerator;
    public static String lastUsedVisualCodeInserter;
    public static String lastUsedOptimization;
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (PanelPluginSelection.this.areConstraintsFulfilled()) {
                PanelPluginSelection.this.errorTextArea.setText("");
                PanelPluginSelection.this.setColorOnAllComboBoxes();
            } else {
                PanelPluginSelection.this.errorTextArea.setText(PanelPluginSelection.this.errorMessage);
                PanelPluginSelection.this.setColorOnAllComboBoxes();
            }
        }
    };

    private boolean isErrorPlugin(JComboBox comboBox) {
        String name = comboBox.getSelectedItem().getClass().getCanonicalName();
        return name.equals(this.errorPlugin1) || name.equals(this.errorPlugin2);
    }

    private void setColorOnAllComboBoxes() {
        if (this.isErrorPlugin(this.visualCodeInserter)) {
            this.visualCodeInserter.setBackground(Color.red);
        } else {
            this.visualCodeInserter.setBackground(this.defaultColor);
        }
        if (this.isErrorPlugin(this.algebra)) {
            this.algebra.setBackground(Color.red);
        } else {
            this.algebra.setBackground(this.defaultColor);
        }
        if (this.isErrorPlugin(this.optimization)) {
            this.optimization.setBackground(Color.red);
        } else {
            this.optimization.setBackground(this.defaultColor);
        }
        if (this.isErrorPlugin(this.generator)) {
            this.generator.setBackground(Color.red);
        } else {
            this.generator.setBackground(this.defaultColor);
        }
    }

    public PanelPluginSelection() {
        final Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        this.setLayout(new GridLayout(7, 1, 5, 5));
        DefaultListCellRenderer c = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                String valueStr = ((Plugin)value).getName();
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, valueStr, index, isSelected, cellHasFocus);
                label.setFont(font);
                Image icon = ((Plugin)value).getIcon();
                if (icon != null) {
                    label.setIcon(new ImageIcon(((Plugin)value).getIcon()));
                }
                return label;
            }
        };
        this.add(new JPanel());
        this.algebraChooser.setFont(font);
        this.addLabeledComponent("Algebra to use:", this.algebraChooser);
        PluginSorter comparator = new PluginSorter();
        GlobalSettingsStrategyPlugin[] globalPlugins = Plugins.getGlobalSettingsStrategyPlugins().toArray(new GlobalSettingsStrategyPlugin[0]);
        Arrays.sort(globalPlugins, comparator);
        this.globalSettings = new JComboBox<GlobalSettingsStrategyPlugin>(globalPlugins);
        this.globalSettings.setFont(font);
        this.globalSettings.setSelectedItem(this.search((Plugin[])globalPlugins, "de.gaalop.globalSettings.Plugin"));
        this.globalSettings.addItemListener(this.itemListener);
        this.globalSettings.setRenderer(c);
        if (Plugins.getGlobalSettingsStrategyPlugins().size() > 1) {
            this.addLabeledComponent("Global Settings Plugin:", this.globalSettings);
        }
        VisualCodeInserterStrategyPlugin[] visPlugins = Plugins.getVisualizerStrategyPlugins().toArray(new VisualCodeInserterStrategyPlugin[0]);
        Arrays.sort(visPlugins, comparator);
        this.visualCodeInserter = new JComboBox<VisualCodeInserterStrategyPlugin>(visPlugins);
        this.visualCodeInserter.setFont(font);
        this.visualCodeInserter.setSelectedItem(this.search((Plugin[])visPlugins, "de.gaalop.visualCodeInserter.Plugin"));
        this.visualCodeInserter.addItemListener(this.itemListener);
        this.visualCodeInserter.setRenderer(c);
        if (Plugins.getVisualizerStrategyPlugins().size() > 1) {
            this.addLabeledComponent("VisualCodeInserter:", this.visualCodeInserter);
        }
        AlgebraStrategyPlugin[] algPlugins = Plugins.getAlgebraStrategyPlugins().toArray(new AlgebraStrategyPlugin[0]);
        Arrays.sort(algPlugins, comparator);
        this.algebra = new JComboBox<AlgebraStrategyPlugin>(algPlugins);
        this.algebra.setSelectedItem(this.search((Plugin[])algPlugins, "de.gaalop.algebra.Plugin"));
        this.algebra.addItemListener(this.itemListener);
        this.algebra.setFont(font);
        this.algebra.setRenderer(c);
        if (Plugins.getAlgebraStrategyPlugins().size() > 1) {
            this.addLabeledComponent("Algebra:", this.algebra);
        }
        OptimizationStrategyPlugin[] optPlugins = Plugins.getOptimizationStrategyPlugins().toArray(new OptimizationStrategyPlugin[0]);
        Arrays.sort(optPlugins, comparator);
        this.optimization = new JComboBox<OptimizationStrategyPlugin>(optPlugins);
        this.optimization.setFont(font);
        this.optimization.setSelectedItem(this.search((Plugin[])optPlugins, "de.gaalop.tba.Plugin"));
        this.optimization.addItemListener(this.itemListener);
        this.optimization.setRenderer(c);
        if (Plugins.getOptimizationStrategyPlugins().size() > 1) {
            this.addLabeledComponent("Optimization:", this.optimization);
        }
        CodeGeneratorPlugin[] codegenPlugins = Plugins.getCodeGeneratorPlugins().toArray(new CodeGeneratorPlugin[0]);
        Arrays.sort(codegenPlugins, comparator);
        this.generator = new JComboBox<CodeGeneratorPlugin>(codegenPlugins);
        this.generator.setFont(font);
        this.generator.addItemListener(this.itemListener);
        this.generator.setRenderer(c);
        if (Plugins.getCodeGeneratorPlugins().size() > 1) {
            this.addLabeledComponent("CodeGenerator:", this.generator);
        }
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setWrapStyleWord(true);
        this.errorTextArea.setBackground(this.getBackground());
        this.add(this.errorTextArea);
        this.defaultColor = this.generator.getBackground();
    }

    private void addLabeledComponent(String label, JComboBox c) {
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        JPanel panel = new JPanel(new GridLayout(2, 1));
        JLabel l = new JLabel(label);
        l.setFont(font);
        panel.add(l);
        panel.add(c);
        this.add(panel);
    }

    public GlobalSettingsStrategyPlugin getGlobalSettingsStrategyPlugin() {
        return (GlobalSettingsStrategyPlugin)this.globalSettings.getSelectedItem();
    }

    public VisualCodeInserterStrategyPlugin getVisualizerStrategyPlugin() {
        return (VisualCodeInserterStrategyPlugin)this.visualCodeInserter.getSelectedItem();
    }

    public AlgebraStrategyPlugin getAlgebraStrategyPlugin() {
        return (AlgebraStrategyPlugin)this.algebra.getSelectedItem();
    }

    public OptimizationStrategyPlugin getOptimizationStrategyPlugin() {
        return (OptimizationStrategyPlugin)this.optimization.getSelectedItem();
    }

    public CodeGeneratorPlugin getCodeGeneratorPlugin() {
        return (CodeGeneratorPlugin)this.generator.getSelectedItem();
    }

    private Object search(Plugin[] plugins, String search) {
        for (Plugin p : plugins) {
            if (!p.getClass().getCanonicalName().equals(search)) continue;
            return p;
        }
        if (plugins.length > 0) {
            return plugins[0];
        }
        return null;
    }

    public boolean areConstraintsFulfilled() {
        this.errorMessage = "";
        this.errorPlugin1 = null;
        this.errorPlugin2 = null;
        LinkedList<Plugin> plugins = new LinkedList<Plugin>();
        plugins.add((Plugin)this.getVisualizerStrategyPlugin());
        plugins.add((Plugin)this.getAlgebraStrategyPlugin());
        plugins.add((Plugin)this.getOptimizationStrategyPlugin());
        plugins.add((Plugin)this.getCodeGeneratorPlugin());
        if (!this.depends("de.gaalop.codegenGapp.Plugin", "de.gaalop.gapp.Plugin", "The GAPPCodeGenerator needs the GAPP Optimizer!", plugins)) {
            return false;
        }
        if (!this.depends("de.gaalop.gappopencl.Plugin", "de.gaalop.gapp.Plugin", "The GAPPOpenCL codeGenerator needs the GAPP Optimizer!", plugins)) {
            return false;
        }
        if (!this.depends("de.gaalop.vis2d.Plugin", "de.gaalop.visualCodeInserter2d.Plugin", "The Vis2d plugin needs the visualCodeInserter2d plugin!", plugins)) {
            return false;
        }
        if (!this.depends("de.gaalop.visualizer.Plugin", "de.gaalop.visualCodeInserter.Plugin", "The Visualizer plugin needs the visualCodeInserter plugin!", plugins)) {
            return false;
        }
        return this.depends("de.gaalop.gappDebugger.Plugin", "de.gaalop.gapp.Plugin", "The GAPP debugger needs the GAPP Optimizer!", plugins);
    }

    private boolean contains(String plugin, LinkedList<Plugin> plugins) {
        for (Plugin p : plugins) {
            if (!p.getClass().getCanonicalName().equals(plugin)) continue;
            return true;
        }
        return false;
    }

    private boolean depends(String plugin, String needs, String message, LinkedList<Plugin> plugins) {
        if (this.contains(plugin, plugins) && !this.contains(needs, plugins)) {
            this.errorMessage = message;
            this.errorPlugin1 = needs;
            this.errorPlugin2 = plugin;
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void refreshAlgebras() {
        VisualCodeInserterStrategyPlugin[] visualCodeInserterStrategyPlugins = Plugins.getVisualizerStrategyPlugins().toArray(new VisualCodeInserterStrategyPlugin[0]);
        this.visualCodeInserter.setSelectedItem(this.search((Plugin[])visualCodeInserterStrategyPlugins, lastUsedVisualCodeInserter));
        OptimizationStrategyPlugin[] optimizationPlugins = Plugins.getOptimizationStrategyPlugins().toArray(new OptimizationStrategyPlugin[0]);
        this.optimization.setSelectedItem(this.search((Plugin[])optimizationPlugins, lastUsedOptimization));
        CodeGeneratorPlugin[] codegenPlugins = Plugins.getCodeGeneratorPlugins().toArray(new CodeGeneratorPlugin[0]);
        this.generator.setSelectedItem(this.search((Plugin[])codegenPlugins, lastUsedGenerator));
        DefaultComboBoxModel<AlgebraChooserItem> model = new DefaultComboBoxModel<AlgebraChooserItem>();
        for (DefinedAlgebra definedAlgebra : de.gaalop.algebra.Plugin.getDefinedAlgebras()) {
            model.addElement(new AlgebraChooserItem(true, definedAlgebra.id, definedAlgebra.id + " - " + definedAlgebra.name));
        }
        AlgebraStrategyPlugin algebra = (AlgebraStrategyPlugin)Plugins.getAlgebraStrategyPlugins().iterator().next();
        try {
            File file;
            File[] dirs;
            Field field = algebra.getClass().getField("additionalBaseDirectory");
            String value = BeanUtils.getProperty((Object)algebra, (String)field.getName()).trim();
            if (!value.isEmpty() && (dirs = (file = new File(value)).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) != null) {
                for (File dir : dirs) {
                    model.addElement(new AlgebraChooserItem(false, dir.getName(), "Own - " + dir.getName()));
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.algebraChooser.setModel(model);
        if (lastUsedAlgebra == null) {
            lastUsedAlgebra = "cga";
            lastUsedAlgebraRessource = true;
        }
        AlgebraChooserItem defaultItem = new AlgebraChooserItem(lastUsedAlgebraRessource, lastUsedAlgebra, "");
        for (int i = 0; i < model.getSize(); ++i) {
            AlgebraChooserItem iItem = (AlgebraChooserItem)model.getElementAt(i);
            if (!defaultItem.algebraName.equals(iItem.algebraName) || defaultItem.ressource != iItem.ressource) continue;
            defaultItem = iItem;
            break;
        }
        this.algebraChooser.setSelectedItem(defaultItem);
    }

    public AlgebraChooserItem getAlgebraToUse() {
        return (AlgebraChooserItem)this.algebraChooser.getSelectedItem();
    }

    public void updateLastUsedPlugins() {
        lastUsedGenerator = this.generator.getSelectedItem().getClass().getCanonicalName();
        lastUsedVisualCodeInserter = this.visualCodeInserter.getSelectedItem().getClass().getCanonicalName();
        lastUsedOptimization = this.optimization.getSelectedItem().getClass().getCanonicalName();
    }
}

