/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.OutputFile;
import de.gaalop.Plugins;
import de.gaalop.globalSettings.Plugin;
import de.gaalop.gui.FontSize;
import de.gaalop.gui.OutputFilePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultForm {
    private JTabbedPane tabbedPane;
    private JPanel contentPane;
    private Log log = LogFactory.getLog(ResultForm.class);

    public ResultForm(Set<OutputFile> files) {
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBorderPainted(true);
        toolBar.setFloatable(false);
        this.contentPane.add((Component)toolBar, "North");
        JButton saveButton = new JButton("Save file");
        saveButton.setFont(font);
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-save.png")));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component component = ResultForm.this.tabbedPane.getSelectedComponent();
                if (component instanceof OutputFilePane) {
                    OutputFilePane outputFile = (OutputFilePane)component;
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setSelectedFile(new File(outputFile.getFile().getName()));
                    int result = fileChooser.showSaveDialog(ResultForm.this.contentPane);
                    if (result == 0) {
                        ResultForm.this.saveToFile(fileChooser.getSelectedFile(), outputFile.getFile().getContent());
                    }
                }
            }
        });
        toolBar.add(saveButton);
        this.tabbedPane = new JTabbedPane();
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setFont(font);
        for (OutputFile file : files) {
            OutputFilePane filePane = new OutputFilePane(file);
            JTextPane textPane = new JTextPane();
            Plugin globalSettings = null;
            for (GlobalSettingsStrategyPlugin p : Plugins.getGlobalSettingsStrategyPlugins()) {
                if (!(p instanceof Plugin)) continue;
                globalSettings = (Plugin)p;
            }
            if (globalSettings != null) {
                int size = globalSettings.getEditorFontSize();
                textPane.setFont(new Font("Monospaced", 0, size));
            } else {
                textPane.setFont(Font.getFont("SansSerif"));
            }
            Font f = textPane.getFont();
            FontMetrics fm = textPane.getFontMetrics(f);
            int width = fm.charWidth(' ');
            int tabSize = 4;
            int n = 100;
            TabStop[] tabs = new TabStop[n];
            for (int i = 1; i <= n; ++i) {
                tabs[i - 1] = new TabStop(width * tabSize * i, 0, 0);
            }
            TabSet tabset = new TabSet(tabs);
            StyleContext cont = StyleContext.getDefaultStyleContext();
            AttributeSet a = cont.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
            textPane.setParagraphAttributes(a, false);
            textPane.setText(file.getContent());
            filePane.setViewportView(textPane);
            this.tabbedPane.add(file.getName(), filePane);
        }
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File toFile, String text) {
        try (PrintWriter printWriter = new PrintWriter(toFile);){
            printWriter.print(text);
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)e);
            JOptionPane.showMessageDialog(this.contentPane, "Unable to save to " + toFile.getAbsolutePath() + "\n" + e, "Error", 0);
        }
    }
}

