/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.CodeParserPlugin;
import de.gaalop.InputFile;
import de.gaalop.Plugin;
import de.gaalop.gui.FileState;
import de.gaalop.gui.FontSize;
import de.gaalop.gui.Main;
import de.gaalop.gui.util.PluginIconUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class SourceFilePanel
extends JPanel {
    private static final long serialVersionUID = -662488304785792145L;
    private static final Map<String, SimpleAttributeSet> KEYWORDS = new HashMap<String, SimpleAttributeSet>();
    private static final Pattern PATTERN;
    private final CodeParserPlugin parserPlugin;
    final JTextPane textPane;
    private final JLabel tabLabel;
    private File file;
    FileState fileState;
    String savedContent;

    public SourceFilePanel(CodeParserPlugin plugin) {
        this(plugin, new File(Main.lastDirectory, "New File"), "");
        this.fileState = FileState.UNSAVED;
    }

    public void setContent(String content) {
        this.savedContent = content;
        this.textPane.setText(content);
        this.formatCode(content);
        this.updateTabLabel();
    }

    public SourceFilePanel(CodeParserPlugin plugin, File file, String content) {
        super(new BorderLayout(), true);
        this.parserPlugin = plugin;
        this.file = file;
        this.fileState = FileState.SAVED;
        this.savedContent = content;
        this.textPane = new JTextPane();
        int fontSize = FontSize.getEditorFontSize();
        int guiFontSize = FontSize.getGuiFontSize();
        this.textPane.setFont(new Font("Monospaced", 0, fontSize));
        this.textPane.setText(content);
        this.formatCode(content);
        this.textPane.addKeyListener(new SetChangedStateListener());
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        this.add((Component)scrollPane, "Center");
        this.tabLabel = plugin.getIcon() != null ? new JLabel("", PluginIconUtil.getSmallIcon((Plugin)plugin), 2) : new JLabel("", 2);
        this.tabLabel.setFont(new Font("Arial", 0, guiFontSize));
        this.updateTabLabel();
    }

    void formatCode(String content) {
        try {
            StyledDocument doc = this.textPane.getStyledDocument();
            Font f = this.textPane.getFont();
            FontMetrics fm = this.textPane.getFontMetrics(f);
            int width = fm.charWidth(' ');
            int tabSize = 4;
            int n = 100;
            TabStop[] tabs = new TabStop[n];
            for (int i = 1; i <= n; ++i) {
                tabs[i - 1] = new TabStop(width * tabSize * i, 0, 0);
            }
            TabSet tabset = new TabSet(tabs);
            StyleContext cont = StyleContext.getDefaultStyleContext();
            AttributeSet a = cont.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
            this.textPane.setParagraphAttributes(a, false);
            Matcher matcher = PATTERN.matcher(content);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                String keyword = matcher.group();
                doc.setCharacterAttributes(start, end - start, KEYWORDS.get(keyword), false);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            this.textPane.setText(content);
        }
    }

    public InputFile getInputFile() {
        return new InputFile(this.file.getName(), this.textPane.getText());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.updateTabLabel();
    }

    void updateTabLabel() {
        if (this.fileState != FileState.SAVED) {
            this.tabLabel.setText(this.file.getName() + "*");
        } else {
            this.tabLabel.setText(this.file.getName());
        }
        Font font = new Font("Arial", 0, FontSize.getGuiFontSize());
        this.tabLabel.setFont(font);
    }

    public CodeParserPlugin getParserPlugin() {
        return this.parserPlugin;
    }

    public JLabel getTabLabel() {
        return this.tabLabel;
    }

    public void setSaved() {
        this.fileState = FileState.SAVED;
        this.savedContent = this.textPane.getText();
        this.updateTabLabel();
    }

    public FileState getFileState() {
        return this.fileState;
    }

    static {
        SimpleAttributeSet keyword = new SimpleAttributeSet();
        StyleConstants.setBold(keyword, true);
        StyleConstants.setForeground(keyword, Color.BLUE);
        SimpleAttributeSet forbidden = new SimpleAttributeSet();
        StyleConstants.setBold(forbidden, true);
        StyleConstants.setForeground(forbidden, Color.RED);
        String regex = "";
        Iterator<String> it = KEYWORDS.keySet().iterator();
        while (it.hasNext()) {
            regex = regex + it.next() + "+";
            if (!it.hasNext()) continue;
            regex = regex + "|";
        }
        PATTERN = Pattern.compile(regex);
    }

    private class SetChangedStateListener
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            if (SourceFilePanel.this.fileState != FileState.UNSAVED) {
                if (SourceFilePanel.this.textPane.getText().equals(SourceFilePanel.this.savedContent)) {
                    SourceFilePanel.this.fileState = FileState.SAVED;
                    SourceFilePanel.this.updateTabLabel();
                } else {
                    SourceFilePanel.this.fileState = FileState.CHANGED;
                    SourceFilePanel.this.updateTabLabel();
                }
            }
            SourceFilePanel.this.formatCode(SourceFilePanel.this.textPane.getText());
        }
    }
}

