/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui.util;

import de.gaalop.ConfigurationProperty;
import de.gaalop.Plugin;
import de.gaalop.Plugins;
import de.gaalop.gui.PanelPluginSelection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginConfigurator {
    private final Properties configuration;
    private Log log = LogFactory.getLog(PluginConfigurator.class);

    public PluginConfigurator(Properties configuration) {
        this.configuration = configuration;
    }

    public PluginConfigurator() {
        this.configuration = new Properties();
    }

    public void configure(Plugin plugin) {
        Field[] fields;
        this.log.debug((Object)("Configuring " + plugin.getClass()));
        for (Field field : fields = plugin.getClass().getFields()) {
            if (!field.isAnnotationPresent(ConfigurationProperty.class)) continue;
            this.configure(plugin, field);
        }
    }

    private void configure(Plugin plugin, Field field) {
        String propertyKey = this.getPropertyKey(field);
        String propertyValue = this.configuration.getProperty(propertyKey);
        this.log.debug((Object)("Configuration for " + propertyKey + " = " + propertyValue));
        if (propertyValue != null) {
            try {
                BeanUtils.setProperty((Object)plugin, (String)field.getName(), (Object)propertyValue);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)("Unable to configure property " + propertyKey), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.log.error((Object)("Unable to configure property " + propertyKey), (Throwable)e);
            }
        }
    }

    private String getPropertyKey(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        String fieldName = field.getName();
        return declaringClass.getName() + "." + fieldName;
    }

    public void configureAll(Observer o) {
        Set plugins = Plugins.getGlobalSettingsStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.configure(plugin);
        }
        plugins = Plugins.getOptimizationStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.configure(plugin);
        }
        plugins = Plugins.getAlgebraStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.configure(plugin);
        }
        plugins = Plugins.getCodeParserPlugins();
        for (Plugin plugin : plugins) {
            this.configure(plugin);
        }
        plugins = Plugins.getCodeGeneratorPlugins();
        for (Plugin plugin : plugins) {
            this.configure(plugin);
        }
        PanelPluginSelection.lastUsedAlgebra = (String)this.configuration.get("lastUsedAlgebra");
        PanelPluginSelection.lastUsedAlgebraRessource = Boolean.parseBoolean((String)this.configuration.get("lastUsedAlgebraRessource"));
        PanelPluginSelection.lastUsedGenerator = (String)this.configuration.get("lastUsedGenerator");
        PanelPluginSelection.lastUsedVisualCodeInserter = (String)this.configuration.get("lastUsedVisualCodeInserter");
        PanelPluginSelection.lastUsedOptimization = (String)this.configuration.get("lastUsedOptimization");
    }

    public void registerAll(Observer o) {
        Set plugins = Plugins.getGlobalSettingsStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.register(plugin, o);
        }
        plugins = Plugins.getOptimizationStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.register(plugin, o);
        }
        plugins = Plugins.getAlgebraStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.register(plugin, o);
        }
        plugins = Plugins.getCodeParserPlugins();
        for (Plugin plugin : plugins) {
            this.register(plugin, o);
        }
        plugins = Plugins.getCodeGeneratorPlugins();
        for (Plugin plugin : plugins) {
            this.register(plugin, o);
        }
        PanelPluginSelection.lastUsedAlgebra = (String)this.configuration.get("lastUsedAlgebra");
        PanelPluginSelection.lastUsedAlgebraRessource = Boolean.parseBoolean((String)this.configuration.get("lastUsedAlgebraRessource"));
        PanelPluginSelection.lastUsedGenerator = (String)this.configuration.get("lastUsedGenerator");
        PanelPluginSelection.lastUsedVisualCodeInserter = (String)this.configuration.get("lastUsedVisualCodeInserter");
        PanelPluginSelection.lastUsedOptimization = (String)this.configuration.get("lastUsedOptimization");
    }

    private void register(Plugin plugin, Observer o) {
        if (plugin.getClass().getSuperclass() == Observable.class) {
            this.log.debug((Object)("Registering " + o + " as observer of " + plugin.getName() + " plugin"));
            ((Observable)plugin).addObserver(o);
        }
    }

    public void readConfiguration() {
        Set plugins = Plugins.getGlobalSettingsStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.readConfiguration(plugin);
        }
        plugins = Plugins.getOptimizationStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.readConfiguration(plugin);
        }
        plugins = Plugins.getAlgebraStrategyPlugins();
        for (Plugin plugin : plugins) {
            this.readConfiguration(plugin);
        }
        plugins = Plugins.getCodeParserPlugins();
        for (Plugin plugin : plugins) {
            this.readConfiguration(plugin);
        }
        plugins = Plugins.getCodeGeneratorPlugins();
        for (Plugin plugin : plugins) {
            this.readConfiguration(plugin);
        }
        this.configuration.put("lastUsedAlgebra", PanelPluginSelection.lastUsedAlgebra);
        this.configuration.put("lastUsedAlgebraRessource", Boolean.toString(PanelPluginSelection.lastUsedAlgebraRessource));
        this.configuration.put("lastUsedGenerator", PanelPluginSelection.lastUsedGenerator);
        this.configuration.put("lastUsedVisualCodeInserter", PanelPluginSelection.lastUsedVisualCodeInserter);
        this.configuration.put("lastUsedOptimization", PanelPluginSelection.lastUsedOptimization);
    }

    private void readConfiguration(Plugin plugin) {
        this.log.debug((Object)("Reading configuration of " + plugin.getClass()));
        Set<Field> fields = this.getAllFields(plugin.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigurationProperty.class)) continue;
            this.readConfiguration(plugin, field);
        }
    }

    private Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            Set<Field> superFields = this.getAllFields(superclass);
            fields.addAll(superFields);
        }
        return fields;
    }

    private void readConfiguration(Plugin plugin, Field field) {
        String propertyKey = this.getPropertyKey(field);
        try {
            String configValue = BeanUtils.getProperty((Object)plugin, (String)field.getName());
            this.log.debug((Object)("Read value for " + propertyKey + " = " + configValue));
            this.configuration.put(propertyKey, configValue);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Unable to read property " + propertyKey), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)("Unable to read property " + propertyKey), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)("No getter is available for " + propertyKey), (Throwable)e);
        }
    }

    public Properties getConfiguration() {
        return this.configuration;
    }
}

