/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.api.dfg;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;

public class RoundingDFGVisitor
implements ExpressionVisitor {
    private Expression result = null;
    private int numberOfDigits;

    public static Expression round(Expression expressionToRound, int numberOfDigits) {
        RoundingDFGVisitor visitor = new RoundingDFGVisitor(numberOfDigits);
        if (expressionToRound != null) {
            expressionToRound.accept((ExpressionVisitor)visitor);
        }
        if (visitor.result != null) {
            return visitor.result;
        }
        return expressionToRound;
    }

    public RoundingDFGVisitor(int numberOfDigits) {
        this.numberOfDigits = numberOfDigits;
    }

    public void visit(Subtraction node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Subtraction(leftResult, rightResult);
        }
    }

    public void visit(Addition node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Addition(leftResult, rightResult);
        }
    }

    public void visit(Division node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Division(leftResult, rightResult);
        }
    }

    public void visit(InnerProduct node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new InnerProduct(leftResult, rightResult);
        }
    }

    public void visit(Multiplication node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Multiplication(leftResult, rightResult);
        }
    }

    public void visit(MathFunctionCall node) {
        this.result = null;
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != null) {
            this.result = new MathFunctionCall(this.result, node.getFunction());
        }
    }

    public void visit(Variable node) {
        this.result = null;
    }

    public void visit(MultivectorComponent node) {
        this.result = null;
    }

    public void visit(Exponentiation node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Exponentiation(leftResult, rightResult);
        }
    }

    public void visit(FloatConstant node) {
        this.result = null;
        double multiplicator = Math.pow(10.0, this.numberOfDigits);
        this.result = new FloatConstant((double)Math.round(node.getValue() * multiplicator) / multiplicator);
    }

    public void visit(OuterProduct node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new OuterProduct(leftResult, rightResult);
        }
    }

    public void visit(BaseVector node) {
        this.result = null;
    }

    public void visit(Negation node) {
        this.result = null;
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != null) {
            this.result = new Negation(this.result);
        }
    }

    public void visit(Reverse node) {
        this.result = null;
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != null) {
            this.result = new Reverse(this.result);
        }
    }

    public void visit(LogicalOr node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new LogicalOr(leftResult, rightResult);
        }
    }

    public void visit(LogicalAnd node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new LogicalAnd(leftResult, rightResult);
        }
    }

    public void visit(LogicalNegation node) {
        this.result = null;
        node.getOperand().accept((ExpressionVisitor)this);
        if (this.result != null) {
            this.result = new LogicalNegation(this.result);
        }
    }

    public void visit(Equality node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Equality(leftResult, rightResult);
        }
    }

    public void visit(Inequality node) {
        this.result = null;
        node.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Inequality(leftResult, rightResult);
        }
    }

    public void visit(Relation relation) {
        this.result = null;
        relation.getLeft().accept((ExpressionVisitor)this);
        Expression leftResult = this.result;
        relation.getRight().accept((ExpressionVisitor)this);
        Expression rightResult = this.result;
        if (leftResult != null || rightResult != null) {
            this.result = new Relation(leftResult, rightResult, relation.getType());
        }
    }

    public void visit(FunctionArgument node) {
        this.result = null;
    }

    public void visit(MacroCall node) {
        this.result = null;
    }
}

