/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.productComputer.BladeStr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class AlgebraPC {
    public String[] base;
    public String[] base2;
    public HashMap<String, Byte> baseSquaresStr;
    public HashMap<String, LinkedList<BladeStr>> mapToPlusMinus;
    public HashMap<String, LinkedList<BladeStr>> mapToZeroInf;

    public AlgebraPC(AlgebraDefinitionFile alFile) {
        this.base = Arrays.copyOfRange(alFile.base, 1, alFile.base.length);
        this.base2 = Arrays.copyOfRange(alFile.base2, 1, alFile.base2.length);
        this.baseSquaresStr = alFile.baseSquares;
        this.mapToPlusMinus = this.parseMapStringListBladeStr(alFile.lineMapZeroInfToPlusMinus);
        this.mapToZeroInf = this.parseMapStringListBladeStr(alFile.lineMapPlusMinusToZeroInf);
    }

    private HashMap<String, LinkedList<BladeStr>> parseMapStringListBladeStr(String str) {
        String[] parts;
        str = str.trim();
        HashMap<String, LinkedList<BladeStr>> result = new HashMap<String, LinkedList<BladeStr>>();
        if (str.isEmpty()) {
            return result;
        }
        for (String part : parts = str.split(",")) {
            String[] parts2 = part.split("=");
            result.put(parts2[0], this.parseListBladeStr(parts2[1]));
        }
        return result;
    }

    private LinkedList<BladeStr> parseListBladeStr(String str) {
        int index;
        LinkedList<BladeStr> result = new LinkedList<BladeStr>();
        while ((index = this.suchenextIndex(str)) != Integer.MAX_VALUE) {
            result.add(this.parseBladeStr(str.substring(0, index)));
            if (str.charAt(index) == '-') {
                str = str.substring(index);
                continue;
            }
            str = str.substring(index + 1);
        }
        if (!str.isEmpty()) {
            result.add(this.parseBladeStr(str));
        }
        return result;
    }

    private int suchenextIndex(String str) {
        int indexPlus = str.indexOf(43);
        int indexMinus = str.indexOf(45, 1);
        if (indexPlus == -1) {
            indexPlus = Integer.MAX_VALUE;
        }
        if (indexMinus == -1) {
            indexMinus = Integer.MAX_VALUE;
        }
        return Math.min(indexPlus, indexMinus);
    }

    private BladeStr parseBladeStr(String str) {
        if (str.contains("*")) {
            return this.parseProduct(str);
        }
        if (str.contains("e")) {
            return this.parseBlade(str);
        }
        return new BladeStr(Float.parseFloat(str.trim()), "0");
    }

    private BladeStr parseBlade(String str) {
        boolean negated = false;
        if (str.charAt(0) == '-') {
            str = str.substring(1);
            negated = true;
        }
        return new BladeStr((float)(negated ? -1 : 1), new String[]{str});
    }

    private BladeStr parseProduct(String str) {
        String[] parts = str.split("\\*");
        if (parts[0].contains("e")) {
            BladeStr result = this.parseBlade(parts[0]);
            result.setPrefactor(result.getPrefactor() * Float.parseFloat(parts[1].trim()));
            return result;
        }
        BladeStr result = this.parseBlade(parts[1]);
        result.setPrefactor(result.getPrefactor() * Float.parseFloat(parts[0].trim()));
        return result;
    }
}

