/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.productComputer.Permutation;
import de.gaalop.productComputer.SignedBlade;
import de.gaalop.productComputer.SumOfBlades;
import java.util.HashMap;

public class BaseTransformation {
    public static SumOfBlades transform(SumOfBlades s, HashMap<Integer, SumOfBlades> map, int bitCount) {
        SumOfBlades result = new SumOfBlades();
        for (SignedBlade blade : s) {
            SumOfBlades[] lengths = new SumOfBlades[bitCount];
            for (int bit = 0; bit < bitCount; ++bit) {
                lengths[bit] = new SumOfBlades();
                if (!blade.get(bit)) continue;
                if (map.containsKey(bit)) {
                    SumOfBlades t = map.get(bit);
                    for (SignedBlade tb : t) {
                        lengths[bit].add(new SignedBlade(bitCount, tb, tb.coefficient));
                    }
                    continue;
                }
                SignedBlade sb = new SignedBlade(bitCount);
                sb.set(bit);
                lengths[bit].add(sb);
            }
            Permutation permutation = new Permutation();
            SignedBlade p = new SignedBlade(bitCount);
            if (permutation.initialize(lengths, p, bitCount)) {
                p.coefficient *= blade.coefficient;
                result.add(p);
            }
            while (permutation.hasNextPermutation()) {
                SignedBlade p1 = new SignedBlade(bitCount);
                if (!permutation.getNextPermutation(lengths, p1, bitCount)) continue;
                p1.coefficient *= blade.coefficient;
                result.add(p1);
            }
        }
        return result;
    }
}

