/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.productComputer.Blade;
import de.gaalop.productComputer.GAMethods;
import de.gaalop.productComputer.ProductCalculator;
import de.gaalop.productComputer.SignedBlade;
import de.gaalop.productComputer.SumOfBlades;

public class GeoProductCalculator
implements ProductCalculator {
    @Override
    public void calcProduct(SignedBlade b1, SignedBlade b2, SumOfBlades result, int bitCount, byte[] squareMask) {
        SignedBlade resultOuter = new SignedBlade(bitCount, b1, b1.coefficient * b2.coefficient * GAMethods.canonicalReorderingSign(b1, b2, bitCount));
        resultOuter.xor(b2);
        if (!b1.intersects(b2)) {
            result.add(resultOuter);
        } else {
            Blade aAndBMasked = new Blade(bitCount, b1);
            aAndBMasked.and(b2);
            for (int index = 0; index < bitCount; ++index) {
                if (!aAndBMasked.get(index)) continue;
                resultOuter.coefficient *= (float)squareMask[index];
            }
            result.add(resultOuter);
        }
    }
}

