/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.productComputer.Blade;
import de.gaalop.productComputer.ProductCalculator;
import de.gaalop.productComputer.SignedBlade;
import de.gaalop.productComputer.SumOfBlades;

public class InnerProductCalculator
implements ProductCalculator {
    private boolean calcInner1Product1(SignedBlade b1, SignedBlade b2, SignedBlade result, int bitCount, byte[] squareMask) {
        result.clear();
        result.coefficient = b1.coefficient * b2.coefficient;
        Blade aAndB = new Blade(bitCount, b1);
        aAndB.and(b2);
        if (aAndB.isEmpty()) {
            return false;
        }
        for (int index = 0; index < bitCount; ++index) {
            if (!aAndB.get(index)) continue;
            result.coefficient *= (float)squareMask[index];
            return squareMask[index] != 0;
        }
        throw new IllegalStateException("InnerProductCalculator.calcInner1Product1: state not allowed");
    }

    private boolean calcInner1Productn(SignedBlade b1, SignedBlade b2, SignedBlade result, int bitCount, byte[] squareMask) {
        Blade aAndBMasked2 = new Blade(bitCount, b1);
        aAndBMasked2.and(b2);
        if (!aAndBMasked2.isEmpty()) {
            result.coefficient = b1.coefficient * b2.coefficient;
            result.clear();
            result.or(b1);
            result.xor(b2);
            boolean negate = false;
            int i = 0;
            while (!b1.get(i)) {
                if (b2.get(i)) {
                    negate = !negate;
                }
                ++i;
            }
            if (negate) {
                result.coefficient *= -1.0f;
            }
            for (int index = 0; index < bitCount; ++index) {
                if (!aAndBMasked2.get(index)) continue;
                result.coefficient *= (float)squareMask[index];
                if (squareMask[index] != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean calcInnernProduct1(SignedBlade b1, SignedBlade b2, SignedBlade result, int bitCount, byte[] squareMask) {
        Blade aAndBMasked3 = new Blade(bitCount, b1);
        aAndBMasked3.and(b2);
        if (!aAndBMasked3.isEmpty()) {
            result.coefficient = b1.coefficient * b2.coefficient;
            result.clear();
            result.or(b1);
            result.xor(b2);
            boolean negate = false;
            int i = bitCount - 1;
            while (!b2.get(i)) {
                if (b1.get(i)) {
                    negate = !negate;
                }
                --i;
            }
            if (negate) {
                result.coefficient *= -1.0f;
            }
            for (int index = 0; index < bitCount; ++index) {
                if (!aAndBMasked3.get(index)) continue;
                result.coefficient *= (float)squareMask[index];
                if (squareMask[index] != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean calcInnernProductn(SignedBlade b1, SignedBlade b2, SignedBlade result, int bitCount, byte[] squareMask) {
        if (b1.cardinality() > b2.cardinality()) {
            SignedBlade b1Cp = new SignedBlade(bitCount, b1, b1.coefficient);
            boolean add = false;
            for (int i = 0; i < bitCount; ++i) {
                if (!b2.get(i)) continue;
                SignedBlade maskedBlade = new SignedBlade(bitCount);
                maskedBlade.set(i);
                SignedBlade toB1Cp = new SignedBlade(bitCount);
                if (!this.calcInnernProduct1(b1Cp, maskedBlade, toB1Cp, bitCount, squareMask)) {
                    return false;
                }
                b1Cp = toB1Cp;
                add = true;
            }
            result.clear();
            result.or(b1Cp);
            result.coefficient *= b1Cp.coefficient * b2.coefficient;
            return add;
        }
        SignedBlade b2Cp = new SignedBlade(bitCount, b2, b2.coefficient);
        boolean add = false;
        for (int i = bitCount - 1; i >= 0; --i) {
            if (!b1.get(i)) continue;
            SignedBlade maskedBlade = new SignedBlade(bitCount);
            maskedBlade.set(i);
            SignedBlade toB2Cp = new SignedBlade(bitCount);
            if (!this.calcInner1Productn(maskedBlade, b2Cp, toB2Cp, bitCount, squareMask)) {
                return false;
            }
            b2Cp = toB2Cp;
            add = true;
        }
        result.clear();
        result.or(b2Cp);
        result.coefficient *= b2Cp.coefficient * b1.coefficient;
        return add;
    }

    @Override
    public void calcProduct(SignedBlade b1, SignedBlade b2, SumOfBlades innerProduct, int bitCount, byte[] squareMask) {
        if (!b1.isEmpty() && !b2.isEmpty()) {
            SignedBlade result = new SignedBlade(bitCount);
            if (b1.cardinality() == 1) {
                if (b2.cardinality() == 1) {
                    if (this.calcInner1Product1(b1, b2, result, bitCount, squareMask)) {
                        innerProduct.add(result);
                    }
                } else if (this.calcInner1Productn(b1, b2, result, bitCount, squareMask)) {
                    innerProduct.add(result);
                }
            } else if (b2.cardinality() == 1) {
                if (this.calcInnernProduct1(b1, b2, result, bitCount, squareMask)) {
                    innerProduct.add(result);
                }
            } else if (this.calcInnernProductn(b1, b2, result, bitCount, squareMask)) {
                innerProduct.add(result);
            }
        }
    }
}

