/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.algebra.AlStrategy;
import de.gaalop.algebra.DefinedAlgebra;
import de.gaalop.algebra.Plugin;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.productComputer.AlgebraPC;
import de.gaalop.productComputer.GeoProductCalculator;
import de.gaalop.productComputer.InnerProductCalculator;
import de.gaalop.productComputer.OuterProductCalculator;
import de.gaalop.productComputer.ProductComputer;
import de.gaalop.tba.MultTableAbsDirectComputer;
import de.gaalop.tba.MultTableImpl;
import de.gaalop.tba.table.TableFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class Main {
    public static void main(String[] args) throws IOException {
        for (DefinedAlgebra definedAlgebra : Plugin.getDefinedAlgebras()) {
            ProductComputer productComputer = new ProductComputer();
            AlgebraDefinitionFile alFile = new AlgebraDefinitionFile();
            alFile.loadFromFile((Reader)new InputStreamReader(AlStrategy.class.getResourceAsStream("algebra/" + definedAlgebra.id + "/definition.csv")));
            AlgebraPC algebraPC = new AlgebraPC(alFile);
            productComputer.initialize(algebraPC);
            int bladeCount = (int)Math.pow(2.0, algebraPC.base.length);
            MultTableImpl inner = new MultTableImpl();
            inner.createTable(bladeCount);
            MultTableImpl outer = new MultTableImpl();
            outer.createTable(bladeCount);
            MultTableImpl geo = new MultTableImpl();
            geo.createTable(bladeCount);
            MultTableAbsDirectComputer innerLive = new MultTableAbsDirectComputer(alFile, new InnerProductCalculator());
            MultTableAbsDirectComputer outerLive = new MultTableAbsDirectComputer(alFile, new OuterProductCalculator());
            MultTableAbsDirectComputer geoLive = new MultTableAbsDirectComputer(alFile, new GeoProductCalculator());
            for (int i = 0; i < bladeCount; ++i) {
                for (int j = 0; j < bladeCount; ++j) {
                    inner.setProduct(i, j, innerLive.getProduct(i, j));
                    outer.setProduct(i, j, outerLive.getProduct(i, j));
                    geo.setProduct(i, j, geoLive.getProduct(i, j));
                }
            }
            TableFormat.writeToFile(bladeCount, algebraPC.base.length, inner, outer, geo, new FileOutputStream("products_" + definedAlgebra.id + ".csv"), 1);
        }
    }
}

