/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.productComputer;

import de.gaalop.productComputer.SignedBlade;
import de.gaalop.productComputer.SumOfBlades;

public class Permutation {
    private int curNo;
    private int count;
    private int[] permutation;

    private boolean permutationToBlade(SumOfBlades[] lengths, SignedBlade result, int i, int bitCount) {
        SumOfBlades s = lengths[i];
        SignedBlade b = (SignedBlade)s.get(this.permutation[i]);
        result.coefficient *= b.coefficient;
        for (int j = 0; j < bitCount; ++j) {
            boolean v = b.get(j);
            if (v && result.get(j)) {
                return false;
            }
            if (!v) continue;
            result.set(j);
            for (int k = j + 1; k < bitCount; ++k) {
                if (!result.get(k)) continue;
                result.coefficient *= -1.0f;
            }
        }
        return true;
    }

    public boolean initialize(SumOfBlades[] lengths, SignedBlade result, int bitCount) {
        int i;
        this.permutation = new int[bitCount];
        result.clear();
        this.curNo = 0;
        this.count = 1;
        for (i = 0; i < bitCount; ++i) {
            if (lengths[i].size() > 0) {
                this.count *= lengths[i].size();
                this.permutation[i] = 0;
                continue;
            }
            this.permutation[i] = -1;
        }
        for (i = 0; i < bitCount; ++i) {
            if (lengths[i].size() <= 0 || this.permutationToBlade(lengths, result, i, bitCount)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNextPermutation() {
        return this.curNo + 1 < this.count;
    }

    public boolean getNextPermutation(SumOfBlades[] lengths, SignedBlade result, int bitCount) {
        ++this.curNo;
        if (this.curNo >= this.count) {
            return false;
        }
        int pos = 0;
        boolean ueberlauf = true;
        while (ueberlauf) {
            if (this.permutation[pos] != -1) {
                boolean bl = ueberlauf = this.permutation[pos] + 1 == lengths[pos].size();
                if (ueberlauf) {
                    this.permutation[pos] = 0;
                } else {
                    int n = pos;
                    this.permutation[n] = this.permutation[n] + 1;
                }
            }
            ++pos;
        }
        result.clear();
        for (int i = 0; i < bitCount; ++i) {
            if (lengths[i].size() <= 0 || this.permutationToBlade(lengths, result, i, bitCount)) continue;
            return false;
        }
        return true;
    }
}

