/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba;

import de.gaalop.tba.Algebra;
import de.gaalop.tba.BladeRef;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;

public class Multivector {
    private Vector<BladeRef> blades = new Vector();

    public void addBlade(BladeRef blade) {
        this.blades.add(blade);
    }

    public TreeMap<Integer, Byte> getValueArr(Algebra algebra) {
        TreeMap<Integer, Byte> result = new TreeMap<Integer, Byte>();
        this.blades.forEach(cur -> result.merge(cur.getIndex(), cur.getPrefactor(), (pL, pR) -> (byte)(pL + pR)));
        LinkedList nullIndices = new LinkedList();
        result.entrySet().forEach(entry -> {
            if ((Byte)entry.getValue() == 0) {
                nullIndices.add((Integer)entry.getKey());
            }
        });
        for (Integer nullIndex : nullIndices) {
            result.remove(nullIndex);
        }
        return result;
    }

    public String toString() {
        return this.blades.toString();
    }

    public Vector<BladeRef> getBlades() {
        return this.blades;
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        block5: for (BladeRef ref : this.blades) {
            switch (ref.getPrefactor()) {
                case -1: {
                    sb.append("-E" + ref.getIndex());
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                case 1: {
                    sb.append("+E" + ref.getIndex());
                    continue block5;
                }
            }
            System.err.println("Only -1,0,1 allowed as prefactors in multivectors");
        }
        if (sb.length() == 0) {
            return "";
        }
        if (sb.charAt(0) == '+') {
            return sb.substring(1);
        }
        return sb.toString();
    }
}

