/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba;

import de.gaalop.algebra.AlStrategy;
import de.gaalop.algebra.BladeArrayRoutines;
import de.gaalop.algebra.TCBlade;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.dfg.Expression;
import de.gaalop.productComputer.GeoProductCalculator;
import de.gaalop.productComputer.InnerProductCalculator;
import de.gaalop.productComputer.OuterProductCalculator;
import de.gaalop.tba.Algebra;
import de.gaalop.tba.IMultTable;
import de.gaalop.tba.MultTableAbsDirectComputer;
import de.gaalop.tba.MultTableImpl;
import de.gaalop.tba.MultTableLoader;
import de.gaalop.tba.Multivector;
import de.gaalop.tba.Products;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UseAlgebra {
    private Algebra algebra;
    private IMultTable tableInner;
    private IMultTable tableOuter;
    private IMultTable tableGeo;

    public UseAlgebra(AlgebraDefinitionFile alFile) {
        boolean productTableExist;
        boolean bl = alFile.isUseAsRessource() ? AlStrategy.class.getResource(alFile.getProductsFilePath()) != null : (productTableExist = new File(alFile.getProductsFilePath()).exists());
        if (alFile.isUsePrecalculatedTable() && productTableExist) {
            this.algebra = new Algebra(alFile);
            this.tableInner = new MultTableImpl();
            this.tableOuter = new MultTableImpl();
            this.tableGeo = new MultTableImpl();
            this.tableInner.createTable(this.algebra.getBladeCount());
            this.tableOuter.createTable(this.algebra.getBladeCount());
            this.tableGeo.createTable(this.algebra.getBladeCount());
            MultTableLoader loader = new MultTableLoader();
            try {
                loader.load(this, alFile.getProductsFilePath(), alFile.isUseAsRessource());
            }
            catch (IOException ex) {
                Logger.getLogger(UseAlgebra.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.tableInner = new MultTableAbsDirectComputer(alFile, new InnerProductCalculator());
            this.tableInner.createTable(0);
            this.tableOuter = new MultTableAbsDirectComputer(alFile, new OuterProductCalculator());
            this.tableOuter.createTable(0);
            this.tableGeo = new MultTableAbsDirectComputer(alFile, new GeoProductCalculator());
            this.tableGeo.createTable(0);
            this.algebra = new Algebra(alFile);
        }
    }

    public UseAlgebra(Algebra algebra, int bladeCount) {
        this.algebra = algebra;
        this.tableInner = new MultTableImpl();
        this.tableOuter = new MultTableImpl();
        this.tableGeo = new MultTableImpl();
        this.tableInner.createTable(bladeCount);
        this.tableOuter.createTable(bladeCount);
        this.tableGeo.createTable(bladeCount);
    }

    public Multivector inner(Integer factor1, Integer factor2) {
        return this.tableInner.getProduct(factor1, factor2);
    }

    public Multivector outer(Integer factor1, Integer factor2) {
        return this.tableOuter.getProduct(factor1, factor2);
    }

    public Multivector geo(Integer factor1, Integer factor2) {
        return this.tableGeo.getProduct(factor1, factor2);
    }

    public int getBladeCount() {
        return this.algebra.getBladeCount();
    }

    public int getGrade(int blade) {
        return this.algebra.getBlade(blade).getBases().size();
    }

    public Algebra getAlgebra() {
        return this.algebra;
    }

    public IMultTable getTableInner() {
        return this.tableInner;
    }

    public IMultTable getTableOuter() {
        return this.tableOuter;
    }

    public IMultTable getTableGeo() {
        return this.tableGeo;
    }

    public static UseAlgebra getCGATable() {
        return UseAlgebra.loadInternalAlgebra("cga", true);
    }

    public static UseAlgebra getCGALive() {
        return UseAlgebra.loadInternalAlgebra("cga", false);
    }

    public static UseAlgebra get3dGA() {
        return UseAlgebra.loadInternalAlgebra("3d", false);
    }

    private static UseAlgebra loadInternalAlgebra(String name, boolean useTable) {
        try {
            AlgebraDefinitionFile alFile = new AlgebraDefinitionFile();
            String baseDirPath = "algebra/" + name + "/";
            alFile.loadFromFile((Reader)new InputStreamReader(AlStrategy.class.getResourceAsStream(baseDirPath + "definition.csv")));
            alFile.setProductsFilePath(baseDirPath + "products.csv");
            alFile.setUseAsRessource(true);
            alFile.setUsePrecalculatedTable(useTable);
            TCBlade[] blades = BladeArrayRoutines.createBlades((String[])Arrays.copyOfRange(alFile.base, 1, alFile.base.length));
            alFile.blades = new Expression[blades.length];
            for (int i = 0; i < blades.length; ++i) {
                alFile.blades[i] = blades[i].toExpression();
            }
            return new UseAlgebra(alFile);
        }
        catch (IOException ex) {
            Logger.getLogger(UseAlgebra.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Multivector getProduct(Products typeProduct, int bladeL, int bladeR) {
        Multivector prodMv = null;
        switch (typeProduct) {
            case INNER: {
                prodMv = this.inner(bladeL, bladeR);
                break;
            }
            case OUTER: {
                prodMv = this.outer(bladeL, bladeR);
                break;
            }
            case GEO: {
                prodMv = this.geo(bladeL, bladeR);
                break;
            }
            default: {
                System.err.println("Product type is unknown!");
            }
        }
        return prodMv;
    }

    public void saveToDir(File dir, int from, int to) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new File(dir, "blades.csv"));
        this.printBlades(out);
        out.close();
        out = new PrintWriter(new File(dir, "products.csv"));
        this.printProducts(out, from, to);
        out.close();
    }

    public void printBlades(PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        for (String b : this.algebra.getBase()) {
            sb.append(";");
            sb.append(b);
        }
        if (this.algebra.getBase().length > 0) {
            out.println(sb.substring(1));
        }
        int bladeCount = this.algebra.getBladeCount();
        for (int blade = 0; blade < bladeCount; ++blade) {
            out.println(this.algebra.getBlade(blade).toString());
        }
    }

    public void printProducts(PrintWriter out, int from, int to) {
        int bladeCount = this.algebra.getBladeCount();
        for (int i = from; i < to; ++i) {
            for (int j = 0; j < bladeCount; ++j) {
                out.print("E");
                out.print(i);
                out.print(";");
                out.print("E");
                out.print(j);
                out.print(";");
                out.print(this.tableInner.getProduct(i, j).print());
                out.print(";");
                out.print(this.tableOuter.getProduct(i, j).print());
                out.print(";");
                out.print(this.tableGeo.getProduct(i, j).print());
                out.println();
            }
        }
    }
}

