/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.baseChange;

import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.productComputer.AlgebraPC;
import de.gaalop.tba.baseChange.AssignedVarsToZIBaseCollector;
import de.gaalop.tba.baseChange.BladeChanger;
import de.gaalop.tba.baseChange.OutputVarsCollector;
import de.gaalop.tba.baseChange.PrefactoredBladeIndex;
import de.gaalop.tba.baseChange.RelevantAssignmentNodeCollector;
import de.gaalop.tba.baseChange.Renamer;
import de.gaalop.tba.cfgImport.optimization.ConstantFolding;
import de.gaalop.visitors.CFGReplaceVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class BaseChanger {
    public static void changeToNormalBase(ControlFlowGraph graph) {
        String prefix = "_coeff_In_e0einf_Basis_";
        AlgebraDefinitionFile alFile = graph.getAlgebraDefinitionFile();
        AlgebraPC alPC = new AlgebraPC(alFile);
        HashMap<String, LinkedList<AssignmentNode>> relevantNodes = BaseChanger.collectRelevantNodes(graph, alFile, alPC);
        BaseChanger.rename(prefix, relevantNodes, graph);
        BaseChanger.doBaseTransformation(relevantNodes, graph, alFile, alPC);
    }

    private static HashMap<String, LinkedList<AssignmentNode>> collectRelevantNodes(ControlFlowGraph graph, AlgebraDefinitionFile alFile, AlgebraPC alPC) {
        OutputVarsCollector outputVarsCollector = new OutputVarsCollector();
        graph.accept((ControlFlowVisitor)outputVarsCollector);
        AssignedVarsToZIBaseCollector assignedVarsToZIBaseCollector = new AssignedVarsToZIBaseCollector(outputVarsCollector.variableNames, alFile, alPC);
        graph.accept((ControlFlowVisitor)assignedVarsToZIBaseCollector);
        RelevantAssignmentNodeCollector nodeCollector = new RelevantAssignmentNodeCollector(assignedVarsToZIBaseCollector.relevantVars);
        graph.accept((ControlFlowVisitor)nodeCollector);
        return nodeCollector.relevantNodes;
    }

    private static void rename(String prefix, HashMap<String, LinkedList<AssignmentNode>> relevantNodes, ControlFlowGraph graph) {
        Renamer renamer = new Renamer(relevantNodes, prefix);
        CFGReplaceVisitor replacer = new CFGReplaceVisitor(renamer){

            public void visit(ExpressionStatement node) {
                node.getSuccessor().accept((ControlFlowVisitor)this);
            }

            public void visit(StoreResultNode node) {
                node.getSuccessor().accept((ControlFlowVisitor)this);
            }
        };
        graph.accept((ControlFlowVisitor)replacer);
    }

    private static void doBaseTransformation(HashMap<String, LinkedList<AssignmentNode>> relevantNodes, ControlFlowGraph graph, AlgebraDefinitionFile alFile, AlgebraPC alPC) {
        BladeChanger bladeChanger = new BladeChanger(alPC, alFile);
        for (String varName : relevantNodes.keySet()) {
            HashMap<Integer, Expression> bladeExpressionsPlusMinus = new HashMap<Integer, Expression>();
            LinkedList<AssignmentNode> nodes = relevantNodes.get(varName);
            for (AssignmentNode node : nodes) {
                int bladeIndex = ((MultivectorComponent)node.getVariable()).getBladeIndex();
                Expression value = node.getValue();
                LinkedList<PrefactoredBladeIndex> list = bladeChanger.transform(bladeIndex);
                for (PrefactoredBladeIndex p : list) {
                    Object exprToAdd = value instanceof FloatConstant && Math.abs(((FloatConstant)value).getValue() - 1.0) < 0.001 ? new FloatConstant((double)p.prefactor) : (Math.abs((double)p.prefactor - 1.0) < 1.0E-4 ? value : new Multiplication((Expression)new FloatConstant((double)p.prefactor), value));
                    bladeExpressionsPlusMinus.put(p.bladeIndex, (Expression)(bladeExpressionsPlusMinus.containsKey(p.bladeIndex) ? new Addition((Expression)bladeExpressionsPlusMinus.get(p.bladeIndex), exprToAdd) : exprToAdd));
                }
            }
            AssignmentNode last = nodes.getLast();
            Object[] indices = bladeExpressionsPlusMinus.keySet().toArray(new Integer[0]);
            Arrays.sort(indices);
            for (Object bladeIndex : indices) {
                Expression value = (Expression)bladeExpressionsPlusMinus.get(bladeIndex);
                ConstantFolding constantFolding = new ConstantFolding();
                value.accept((ExpressionVisitor)constantFolding);
                if (constantFolding.isGraphModified()) {
                    value = constantFolding.getResultExpr();
                }
                AssignmentNode newNode = new AssignmentNode(graph, (Variable)new MultivectorComponent(varName, ((Integer)bladeIndex).intValue()), value);
                last.insertAfter((SequentialNode)newNode);
                last = newNode;
            }
        }
    }
}

