/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.baseChange;

import de.gaalop.algebra.BladeArrayRoutines;
import de.gaalop.algebra.TCBlade;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.productComputer.AlgebraPC;
import de.gaalop.productComputer.BladeStr;
import de.gaalop.productComputer.BubbleSort;
import de.gaalop.tba.baseChange.PrefactoredBladeIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class BladeChanger {
    private final AlgebraPC algebraPC;
    private final AlgebraDefinitionFile algebraDefinitionFile;
    private final TCBlade[] blades;

    public BladeChanger(AlgebraPC algebraPC, AlgebraDefinitionFile alFile) {
        this.algebraPC = algebraPC;
        this.algebraDefinitionFile = alFile;
        this.blades = BladeArrayRoutines.createBlades((String[])algebraPC.base2);
    }

    private static boolean duplicates(String[] array) {
        HashSet<String> set = new HashSet<String>();
        for (String i : array) {
            if (set.contains(i)) {
                return true;
            }
            set.add(i);
        }
        return false;
    }

    private static LinkedList<BladeStr> cartesian(LinkedList<LinkedList<BladeStr>> list) {
        if (list.size() == 1) {
            return list.getFirst();
        }
        LinkedList<BladeStr> result = new LinkedList<BladeStr>();
        LinkedList<LinkedList<BladeStr>> subList = new LinkedList<LinkedList<BladeStr>>(list);
        LinkedList<BladeStr> thisElement = subList.removeFirst();
        LinkedList<BladeStr> subResult = BladeChanger.cartesian(subList);
        for (BladeStr comp : thisElement) {
            for (BladeStr subResultComp : subResult) {
                LinkedList both = new LinkedList();
                Collections.addAll(both, comp.getBaseVectors());
                Collections.addAll(both, subResultComp.getBaseVectors());
                BladeStr b = new BladeStr(comp.getPrefactor() * subResultComp.getPrefactor(), both.toArray(new String[both.size()]));
                if (BladeChanger.duplicates(b.getBaseVectors())) continue;
                result.add(b);
            }
        }
        return result;
    }

    public LinkedList<PrefactoredBladeIndex> transform(int fromIndex) {
        String[] parts;
        if (fromIndex == 0) {
            LinkedList<PrefactoredBladeIndex> result = new LinkedList<PrefactoredBladeIndex>();
            result.add(new PrefactoredBladeIndex(1.0f, 0));
            return result;
        }
        String bladeString = this.algebraDefinitionFile.getBladeString(fromIndex);
        bladeString = bladeString.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(" ", "");
        LinkedList<LinkedList<BladeStr>> bladeExpressionTransformed = new LinkedList<LinkedList<BladeStr>>();
        for (String part : parts = bladeString.split("\\^")) {
            LinkedList<BladeStr> e = new LinkedList<BladeStr>();
            if (this.algebraPC.mapToPlusMinus.containsKey(part)) {
                e.addAll((Collection)this.algebraPC.mapToPlusMinus.get(part));
            } else {
                e.add(new BladeStr(part));
            }
            bladeExpressionTransformed.add(e);
        }
        LinkedList<BladeStr> cartesianResult = BladeChanger.cartesian(bladeExpressionTransformed);
        for (BladeStr b : cartesianResult) {
            Object[] arr = this.baseVectorArrToIntArr(b.getBaseVectors());
            int numExchanges = BubbleSort.doBubbleSort((Integer[])arr);
            if (numExchanges % 2 == 1) {
                b.setPrefactor(-b.getPrefactor());
            }
            Arrays.sort(arr);
            b.setBaseVectors(this.intArrToBaseVectorArr((Integer[])arr));
        }
        HashMap<Integer, PrefactoredBladeIndex> result = new HashMap<Integer, PrefactoredBladeIndex>();
        for (BladeStr b : cartesianResult) {
            PrefactoredBladeIndex p;
            Integer index = this.baseVectorArrToIndex(new TCBlade(b.getBaseVectors()));
            if (result.containsKey(index)) {
                p = (PrefactoredBladeIndex)result.get(index);
            } else {
                p = new PrefactoredBladeIndex(0.0f, index);
                result.put(index, p);
            }
            p.prefactor += b.getPrefactor();
        }
        return new LinkedList<PrefactoredBladeIndex>(result.values());
    }

    private Integer[] baseVectorArrToIntArr(String[] baseVectorArr) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (String baseVector : baseVectorArr) {
            result.add(this.getIndexInArray(baseVector, this.algebraPC.base2));
        }
        return result.toArray(new Integer[0]);
    }

    private String[] intArrToBaseVectorArr(Integer[] intArr) {
        LinkedList<String> result = new LinkedList<String>();
        for (Integer i : intArr) {
            result.add(this.algebraPC.base2[i]);
        }
        return result.toArray(new String[0]);
    }

    private int getIndexInArray(String str, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    private Integer baseVectorArrToIndex(TCBlade blade) {
        for (int i = 0; i < this.blades.length; ++i) {
            if (!Arrays.equals(blade.getBase(), this.blades[i].getBase())) continue;
            return i;
        }
        return null;
    }
}

