/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport;

import de.gaalop.LoggingListenerGroup;
import de.gaalop.OptimizationException;
import de.gaalop.algebra.UpdateLocalVariableSet;
import de.gaalop.api.cfg.RoundingCFGVisitor;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.Plugin;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.baseChange.BaseChanger;
import de.gaalop.tba.cfgImport.CFGImporter;
import de.gaalop.tba.cfgImport.ContainsControlFlow;
import de.gaalop.tba.cfgImport.DivisionRemover;
import de.gaalop.tba.cfgImport.GetMultipleAssignments;
import de.gaalop.tba.cfgImport.MathFunctionSeparator;
import de.gaalop.tba.cfgImport.VariablesCollector;
import de.gaalop.tba.cfgImport.optimization.OptConstantPropagation;
import de.gaalop.tba.cfgImport.optimization.OptGCSE;
import de.gaalop.tba.cfgImport.optimization.OptMaxima;
import de.gaalop.tba.cfgImport.optimization.OptOneExpressionsRemoval;
import de.gaalop.tba.cfgImport.optimization.OptUnusedAssignmentsRemoval;
import de.gaalop.tba.cfgImport.optimization.OptimizationStrategyWithModifyFlag;
import java.util.LinkedList;

public class CFGImporterFacade {
    private LinkedList<OptimizationStrategyWithModifyFlag> optimizations;
    private Plugin plugin;
    private UseAlgebra usedAlgebra;
    private LoggingListenerGroup listeners;

    public CFGImporterFacade(Plugin plugin) {
        this.plugin = plugin;
        this.listeners = new LoggingListenerGroup();
        this.optimizations = new LinkedList();
        if (plugin.isOptConstantPropagation()) {
            this.optimizations.add(new OptConstantPropagation());
        }
        if (plugin.isOptUnusedAssignments()) {
            this.optimizations.add(new OptUnusedAssignmentsRemoval());
        }
        if (plugin.isOptOneExpressionRemoval()) {
            this.optimizations.add(new OptOneExpressionsRemoval());
        }
    }

    public void setProgressListeners(LoggingListenerGroup progressListeners) {
        this.listeners = progressListeners;
    }

    public ControlFlowGraph importGraph(ControlFlowGraph graph) throws OptimizationException {
        boolean repeat;
        this.usedAlgebra = new UseAlgebra(graph.getAlgebraDefinitionFile());
        if (ContainsControlFlow.containsControlFlow(graph)) {
            throw new OptimizationException("Due to Control Flow Existence in Source, TBA isn't assigned on graph!", graph);
        }
        Variable v = GetMultipleAssignments.getMulipleAssignments(graph);
        if (v != null) {
            throw new OptimizationException("Due to Existence of multiple assignments of variable '" + v.getName() + "' in source, TBA isn't assigned on graph!", graph);
        }
        if (!this.plugin.isInvertTransformation()) {
            DivisionRemover divisionRemover = new DivisionRemover();
            graph.accept((ControlFlowVisitor)divisionRemover);
        }
        if (!this.plugin.isScalarFunctions()) {
            VariablesCollector collector = new VariablesCollector();
            graph.accept((ControlFlowVisitor)collector);
            MathFunctionSeparator mathFunctionSeparator = new MathFunctionSeparator(collector.getVariables());
            graph.accept((ControlFlowVisitor)mathFunctionSeparator);
        }
        CFGImporter builder = new CFGImporter(this.usedAlgebra, this.plugin.isScalarFunctions(), graph.getAlgebraDefinitionFile());
        graph.accept((ControlFlowVisitor)builder);
        if (graph.globalSettings.outputToNormalBase) {
            BaseChanger.changeToNormalBase(graph);
        }
        do {
            repeat = false;
            for (OptimizationStrategyWithModifyFlag curOpt : this.optimizations) {
                repeat = repeat || curOpt.transform(graph, this.usedAlgebra, this.listeners);
            }
        } while (repeat);
        if (graph.globalSettings.isOptMaxima()) {
            OptMaxima optMaxima = new OptMaxima(graph.globalSettings.getMaximaCommand(), this.plugin);
            optMaxima.transform(graph, this.usedAlgebra, this.listeners);
            do {
                repeat = false;
                for (OptimizationStrategyWithModifyFlag curOpt : this.optimizations) {
                    repeat = repeat || curOpt.transform(graph, this.usedAlgebra, this.listeners);
                }
            } while (repeat);
        }
        if (this.plugin.isOptGCSE()) {
            new OptGCSE(graph.globalSettings.isOptMaxima(), graph.globalSettings.getMaximaCommand(), this.plugin.createVariablesInGCSE).transform(graph, this.usedAlgebra, this.listeners);
        }
        UpdateLocalVariableSet.updateVariableSets((ControlFlowGraph)graph);
        if (this.plugin.isDoRoundingAfterOptimization()) {
            graph.accept((ControlFlowVisitor)new RoundingCFGVisitor(this.plugin.getNumberOfRoundingDigits()));
        }
        return graph;
    }

    public UseAlgebra getUsedAlgebra() {
        return this.usedAlgebra;
    }
}

