/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;
import de.gaalop.visitors.ExpressionTypeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class MathFunctionSeparator
extends EmptyControlFlowVisitor {
    private Expression resultValue = null;
    private int tempCounter = -1;
    private HashSet<String> variables;
    private HashMap<Variable, Expression> toInsert = new HashMap();
    private LinkedList<Variable> toInsertVars = new LinkedList();
    private ExpressionVisitor expressionVisitor = new ExpressionTypeVisitor(){

        protected void visitBinaryOperation(BinaryOperation node) {
            MathFunctionSeparator.this.resultValue = null;
            node.getLeft().accept((ExpressionVisitor)this);
            if (MathFunctionSeparator.this.resultValue != null) {
                node.setLeft(MathFunctionSeparator.this.resultValue);
                MathFunctionSeparator.this.resultValue = null;
            }
            node.getRight().accept((ExpressionVisitor)this);
            if (MathFunctionSeparator.this.resultValue != null) {
                node.setRight(MathFunctionSeparator.this.resultValue);
                MathFunctionSeparator.this.resultValue = null;
            }
        }

        protected void visitUnaryOperation(UnaryOperation node) {
            MathFunctionSeparator.this.resultValue = null;
            node.getOperand().accept((ExpressionVisitor)this);
            if (MathFunctionSeparator.this.resultValue != null) {
                node.setOperand(MathFunctionSeparator.this.resultValue);
                MathFunctionSeparator.this.resultValue = null;
            }
        }

        protected void visitTerminal(Expression node) {
        }

        public void visit(MathFunctionCall node) {
            MathFunctionSeparator.this.resultValue = null;
            node.getOperand().accept((ExpressionVisitor)this);
            if (MathFunctionSeparator.this.resultValue != null) {
                node.setOperand(MathFunctionSeparator.this.resultValue);
                MathFunctionSeparator.this.resultValue = null;
            } else {
                Variable var = MathFunctionSeparator.this.getNewTemporaryVariable();
                MathFunctionSeparator.this.toInsert.put(var, node.getOperand());
                MathFunctionSeparator.this.toInsertVars.add(var);
                node.setOperand((Expression)var);
            }
            Variable var2 = MathFunctionSeparator.this.getNewTemporaryVariable();
            MathFunctionSeparator.this.toInsert.put(var2, node);
            MathFunctionSeparator.this.toInsertVars.add(var2);
            MathFunctionSeparator.this.resultValue = (Expression)var2;
        }
    };

    public MathFunctionSeparator(HashSet<String> variables) {
        this.variables = variables;
    }

    private Variable getNewTemporaryVariable() {
        ++this.tempCounter;
        while (this.variables.contains("temp" + this.tempCounter)) {
            ++this.tempCounter;
        }
        return new Variable("temp" + this.tempCounter);
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept(this.expressionVisitor);
        if (this.resultValue != null) {
            this.toInsertVars.remove((Variable)this.resultValue);
            this.resultValue = null;
        }
        for (Variable var : this.toInsertVars) {
            AssignmentNode newNode = new AssignmentNode(node.getGraph(), var, this.toInsert.get(var));
            node.insertBefore((SequentialNode)newNode);
        }
        this.toInsertVars.clear();
        this.toInsert.clear();
        super.visit(node);
    }
}

