/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport;

import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunction;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.Algebra;
import de.gaalop.tba.Multivector;
import de.gaalop.tba.Products;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.MvExpressions;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MvExpressionsBuilder
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    public HashMap<String, MvExpressions> variables;
    public HashMap<Expression, MvExpressions> expressions;
    private int counterMv;
    public int bladeCount;
    private UseAlgebra usedAlgebra;
    private boolean scalarFunctions;
    private Variable curVariable;
    private AlgebraDefinitionFile alFile;

    public MvExpressionsBuilder(UseAlgebra usedAlgebra, boolean scalarFunctions, AlgebraDefinitionFile alFile) {
        this.scalarFunctions = scalarFunctions;
        this.alFile = alFile;
        this.variables = new HashMap();
        this.usedAlgebra = usedAlgebra;
        this.counterMv = 0;
        this.bladeCount = usedAlgebra.getBladeCount();
        this.expressions = new HashMap();
    }

    protected AssignmentNode changeGraph(AssignmentNode node, MvExpressions mvExpr, Variable variable) {
        return node;
    }

    public void visit(AssignmentNode node) {
        this.curVariable = node.getVariable();
        Expression value = node.getValue();
        value.accept((ExpressionVisitor)this);
        MvExpressions mvExpr = this.expressions.get(value);
        this.variables.put(this.curVariable.toString(), mvExpr);
        AssignmentNode lastNode = node;
        if (this.scalarFunctions) {
            lastNode = this.changeGraph(node, mvExpr, this.curVariable);
        } else if (!(value instanceof MathFunctionCall)) {
            lastNode = this.changeGraph(node, mvExpr, this.curVariable);
        }
        lastNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    private MvExpressions createNewMvExpressions() {
        ++this.counterMv;
        return new MvExpressions(this.counterMv + "", this.bladeCount);
    }

    private MvExpressions calculateUsingMultTable(Products typeProduct, MvExpressions left, MvExpressions right) {
        MvExpressions result = this.createNewMvExpressions();
        Algebra algebra = this.usedAlgebra.getAlgebra();
        boolean set = false;
        for (Map.Entry<Integer, Expression> l : left.bladeExpressions.entrySet()) {
            for (Map.Entry<Integer, Expression> r : right.bladeExpressions.entrySet()) {
                Multiplication prodExpr = new Multiplication(l.getValue(), r.getValue());
                Multivector prodMv = this.usedAlgebra.getProduct(typeProduct, l.getKey(), r.getKey());
                TreeMap<Integer, Byte> prod = prodMv.getValueArr(algebra);
                for (Map.Entry<Integer, Byte> blade : prod.entrySet()) {
                    Multiplication prodExpri = new Multiplication((Expression)prodExpr, (Expression)new FloatConstant((double)blade.getValue().byteValue()));
                    if (result.bladeExpressions.containsKey(blade.getKey())) {
                        result.setExpression(blade.getKey(), (Expression)new Addition(result.bladeExpressions.get(blade.getKey()), (Expression)prodExpri));
                        continue;
                    }
                    set = true;
                    result.setExpression(blade.getKey(), (Expression)prodExpri);
                }
            }
        }
        if (!set) {
            result.setExpression(0, (Expression)new FloatConstant(0.0));
        }
        return result;
    }

    private void calculateUsingMultTable(Products typeProduct, BinaryOperation node) {
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.calculateUsingMultTable(typeProduct, left, right);
        this.expressions.put((Expression)node, result);
    }

    private void traverseBinary(BinaryOperation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        node.getRight().accept((ExpressionVisitor)this);
    }

    private void traverseUnary(UnaryOperation node) {
        node.getOperand().accept((ExpressionVisitor)this);
    }

    public void visit(Subtraction node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions.putAll(left.bladeExpressions);
        right.bladeExpressions.entrySet().forEach(r -> result.bladeExpressions.put((Integer)r.getKey(), (Expression)(result.bladeExpressions.containsKey(r.getKey()) ? new Subtraction(result.bladeExpressions.get(r.getKey()), (Expression)r.getValue()) : new Negation((Expression)r.getValue()))));
        this.expressions.put((Expression)node, result);
    }

    public void visit(Addition node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions left = this.expressions.get(node.getLeft());
        MvExpressions right = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.bladeExpressions.putAll(left.bladeExpressions);
        right.bladeExpressions.forEach((bladeIndex, expr) -> result.bladeExpressions.merge((Integer)bladeIndex, (Expression)expr, (vL, vR) -> new Addition(vL, vR)));
        this.expressions.put((Expression)node, result);
    }

    private MvExpressions getReverse(MvExpressions mv) {
        MvExpressions result = this.createNewMvExpressions();
        mv.bladeExpressions.entrySet().forEach(blade -> {
            int k = this.usedAlgebra.getGrade((Integer)blade.getKey());
            if (k * (k - 1) / 2 % 2 == 0) {
                result.bladeExpressions.put((Integer)blade.getKey(), (Expression)blade.getValue());
            } else {
                result.bladeExpressions.put((Integer)blade.getKey(), (Expression)new Negation((Expression)blade.getValue()));
            }
        });
        return result;
    }

    private MvExpressions getInverse(MvExpressions mv) {
        MvExpressions revR = this.getReverse(mv);
        MvExpressions length = this.calculateUsingMultTable(Products.GEO, mv, revR);
        Expression lengthScalar = length.bladeExpressions.get(0);
        MvExpressions result = this.createNewMvExpressions();
        revR.bladeExpressions.entrySet().forEach(blade -> result.bladeExpressions.put((Integer)blade.getKey(), (Expression)new Division(((Expression)blade.getValue()).copy(), lengthScalar)));
        return result;
    }

    public void visit(Division node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions inverse = this.getInverse(r);
        MvExpressions result = this.calculateUsingMultTable(Products.GEO, l, inverse);
        this.expressions.put((Expression)node, result);
    }

    public void visit(InnerProduct node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.INNER, (BinaryOperation)node);
    }

    public void visit(Multiplication node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.GEO, (BinaryOperation)node);
    }

    public void visit(MathFunctionCall node) {
        MvExpressions result = this.createNewMvExpressions();
        if (this.scalarFunctions) {
            this.traverseUnary((UnaryOperation)node);
            switch (node.getFunction()) {
                case ABS: {
                    MvExpressions opR;
                    MvExpressions prod;
                    Expression i0;
                    MvExpressions op = this.expressions.get(node.getOperand());
                    if (op.getExpression(0) != null) {
                        boolean allOthersAreNull = true;
                        boolean firstElement = true;
                        for (Expression expr : op.getAllExpressions()) {
                            if (firstElement) {
                                firstElement = false;
                                continue;
                            }
                            if (expr == null) continue;
                            allOthersAreNull = false;
                        }
                        if (allOthersAreNull) {
                            result.setExpression(0, (Expression)new MathFunctionCall(op.getExpression(0), MathFunction.ABS));
                            break;
                        }
                    }
                    if ((i0 = (prod = this.calculateUsingMultTable(Products.GEO, op, opR = this.getReverse(op))).getExpression(0)) == null) {
                        i0 = new FloatConstant(0.0);
                    }
                    result.setExpression(0, (Expression)new MathFunctionCall((Expression)new MathFunctionCall(i0, MathFunction.ABS), MathFunction.SQRT));
                    break;
                }
                case SQRT: {
                    result.setExpression(0, (Expression)new MathFunctionCall(this.expressions.get(node.getOperand()).getExpression(0), MathFunction.SQRT));
                    break;
                }
                default: {
                    result.setExpression(0, (Expression)new MathFunctionCall(this.expressions.get(node.getOperand()).getExpression(0), node.getFunction()));
                    System.err.println("Warning: " + node.getFunction().toString() + " is only implemented for scalar inputs!");
                    break;
                }
            }
        } else {
            for (int blade = 0; blade < this.bladeCount; ++blade) {
                result.setExpression(blade, (Expression)new MultivectorComponent(this.curVariable.getName(), blade));
            }
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(Variable node) {
        MvExpressions result = this.createNewMvExpressions();
        String key = node.toString();
        if (this.variables.containsKey(key)) {
            MvExpressions variableValue = this.variables.get(key);
            String varName = node.getName();
            variableValue.bladeExpressions.entrySet().forEach(blade -> result.bladeExpressions.put((Integer)blade.getKey(), (Expression)new MultivectorComponent(varName, ((Integer)blade.getKey()).intValue())));
        } else {
            result.setExpression(0, (Expression)node);
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(MultivectorComponent node) {
        this.expressions.put((Expression)node, this.variables.get(node.toString()));
    }

    public void visit(FloatConstant node) {
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)node);
        this.expressions.put((Expression)node, result);
    }

    public void visit(OuterProduct node) {
        this.traverseBinary((BinaryOperation)node);
        this.calculateUsingMultTable(Products.OUTER, (BinaryOperation)node);
    }

    public void visit(BaseVector node) {
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(this.alFile.getIndex(node.toString()), (Expression)new FloatConstant(1.0));
        this.expressions.put((Expression)node, result);
    }

    public void visit(Negation node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.createNewMvExpressions();
        op.bladeExpressions.entrySet().forEach(blade -> result.bladeExpressions.put((Integer)blade.getKey(), (Expression)new Negation((Expression)blade.getValue())));
        this.expressions.put((Expression)node, result);
    }

    public void visit(Reverse node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.getReverse(op);
        this.expressions.put((Expression)node, result);
    }

    public void visit(LogicalOr node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new LogicalOr(l.getExpression(0), r.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalOr is only implemented for scalars!");
    }

    public void visit(LogicalAnd node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new LogicalAnd(l.getExpression(0), r.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalAnd is only implemented for scalars!");
    }

    public void visit(LogicalNegation node) {
        this.traverseUnary((UnaryOperation)node);
        MvExpressions op = this.expressions.get(node.getOperand());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new LogicalNegation(op.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: LogicalNegation is only implemented for scalars!");
    }

    public void visit(Equality node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new Equality(l.getExpression(0), r.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Equality is only implemented for scalars!");
    }

    public void visit(Inequality node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new Inequality(l.getExpression(0), r.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Inequality is only implemented for scalars!");
    }

    public void visit(Relation node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        if (node.getType() == Relation.Type.COEFFICIENT) {
            Multiplication sum = null;
            for (Map.Entry<Integer, Expression> blade : r.bladeExpressions.entrySet()) {
                if (!l.bladeExpressions.containsKey(blade.getKey())) continue;
                Multiplication summand = new Multiplication(l.bladeExpressions.get(blade.getKey()), blade.getValue());
                sum = sum == null ? summand : new Addition((Expression)sum, (Expression)summand);
            }
            if (sum != null) {
                result.setExpression(0, (Expression)sum);
            }
        } else {
            result.setExpression(0, (Expression)new Relation(l.getExpression(0), r.getExpression(0), node.getType()));
            System.err.println("Warning: Relation is only implemented for scalars!");
        }
        this.expressions.put((Expression)node, result);
    }

    public void visit(Exponentiation node) {
        this.traverseBinary((BinaryOperation)node);
        MvExpressions l = this.expressions.get(node.getLeft());
        MvExpressions r = this.expressions.get(node.getRight());
        MvExpressions result = this.createNewMvExpressions();
        result.setExpression(0, (Expression)new Exponentiation(l.getExpression(0), r.getExpression(0)));
        this.expressions.put((Expression)node, result);
        System.err.println("Warning: Exponentiation is only implemented for scalars!");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined and no macro calls should be in the graph.");
    }
}

