/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.optimization.DFGVisitorUsedVariables;
import de.gaalop.tba.cfgImport.optimization.VariableComponent;
import de.gaalop.tba.cfgImport.optimization.VariableUsage;
import java.util.HashMap;
import java.util.LinkedList;

public class CFGVisitorUsedVariables
implements ControlFlowVisitor {
    private VariableUsage variableUsage = new VariableUsage();
    private DFGVisitorUsedVariables dfgVisitorusedVariables = new DFGVisitorUsedVariables();
    private HashMap<String, LinkedList<Integer>> outputBlades;
    private UseAlgebra usedAlgebra;
    private LinkedList<SequentialNode> nodeRemovals = new LinkedList();

    public CFGVisitorUsedVariables(HashMap<String, LinkedList<Integer>> outputBlades, UseAlgebra usedAlgebra) {
        this.outputBlades = outputBlades;
        this.usedAlgebra = usedAlgebra;
    }

    public LinkedList<SequentialNode> getNodeRemovals() {
        return this.nodeRemovals;
    }

    public void visit(AssignmentNode node) {
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getVariable().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        VariableComponent variable = this.dfgVisitorusedVariables.getVariables().getFirst();
        if (!this.variableUsage.isUsed(variable)) {
            this.nodeRemovals.addFirst((SequentialNode)node);
        } else {
            this.variableUsage.addDefinition(variable);
            this.dfgVisitorusedVariables.getVariables().clear();
            node.getValue().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
            for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
                this.variableUsage.addUsage(component);
            }
        }
    }

    public void visit(StoreResultNode node) {
        String name = node.getValue().getName();
        if (this.outputBlades.containsKey(name)) {
            for (Integer bladeIndex : this.outputBlades.get(name)) {
                this.variableUsage.addUsage(new VariableComponent(name, bladeIndex, (Expression)node.getValue()));
            }
        } else {
            int bladeCount = this.usedAlgebra.getBladeCount();
            for (int blade = 0; blade < bladeCount; ++blade) {
                this.variableUsage.addUsage(new VariableComponent(name, blade, (Expression)node.getValue()));
            }
        }
    }

    public void visit(ExpressionStatement node) {
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getExpression().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
            this.variableUsage.addUsage(component);
        }
    }

    public void visit(ColorNode node) {
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getR().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
            this.variableUsage.addUsage(component);
        }
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getG().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
            this.variableUsage.addUsage(component);
        }
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getB().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
            this.variableUsage.addUsage(component);
        }
        this.dfgVisitorusedVariables.getVariables().clear();
        node.getAlpha().accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent component : this.dfgVisitorusedVariables.getVariables()) {
            this.variableUsage.addUsage(component);
        }
    }

    public void visit(StartNode node) {
    }

    public void visit(IfThenElseNode node) {
    }

    public void visit(BlockEndNode node) {
    }

    public void visit(LoopNode node) {
    }

    public void visit(BreakNode node) {
    }

    public void visit(Macro node) {
    }

    public void visit(EndNode node) {
    }
}

