/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.api.cfg.GetAllOutputBlades;
import de.gaalop.api.dfg.DFGNodeType;
import de.gaalop.api.dfg.DFGNodeTypeGetter;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.optimization.DFGVisitorUsedVariables;
import de.gaalop.tba.cfgImport.optimization.ExpressionReplacer;
import de.gaalop.tba.cfgImport.optimization.VariableComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class OneExpressionRemoval
extends EmptyControlFlowVisitor {
    private boolean graphModified = false;
    private HashSet<VariableComponent> tabuVariables = new HashSet();
    private HashMap<VariableComponent, VariableComponent> mapOneExpressions = new HashMap();
    private DFGVisitorUsedVariables dfgVisitorusedVariables = new DFGVisitorUsedVariables();
    private LinkedList<SequentialNode> nodeRemovals = new LinkedList();
    private UseAlgebra usedAlgebra;

    public OneExpressionRemoval(UseAlgebra usedAlgebra) {
        this.usedAlgebra = usedAlgebra;
    }

    public LinkedList<SequentialNode> getNodeRemovals() {
        return this.nodeRemovals;
    }

    public boolean isGraphModified() {
        return this.graphModified;
    }

    private void setGraphModified() {
        this.graphModified = true;
    }

    public void visit(StartNode node) {
        this.tabuVariables.addAll(GetAllOutputBlades.getAllOutputBlades(node.getGraph(), this.usedAlgebra));
        int bladeCount = this.usedAlgebra.getBladeCount();
        for (String var : node.getGraph().getPragmaOnlyEvaluateVariables()) {
            for (int blade = 0; blade < bladeCount; ++blade) {
                this.tabuVariables.add(new VariableComponent(var, blade, null));
            }
        }
        super.visit(node);
    }

    private Expression performExpressionReplacements(Expression value) {
        this.dfgVisitorusedVariables.getVariables().clear();
        value.accept((ExpressionVisitor)this.dfgVisitorusedVariables);
        for (VariableComponent variable : this.dfgVisitorusedVariables.getVariables()) {
            if (!this.mapOneExpressions.containsKey(variable)) continue;
            Expression toReplace = variable.getReferredExpression();
            Expression replacement = this.mapOneExpressions.get(variable).getReferredExpression();
            ExpressionReplacer replacer = new ExpressionReplacer(toReplace, replacement);
            value = replacer.replace(value);
            this.setGraphModified();
        }
        return value;
    }

    public void visit(AssignmentNode node) {
        DFGNodeType typeValue;
        Expression value = node.getValue();
        node.setValue(this.performExpressionReplacements(value));
        this.mapOneExpressions.remove(this.getVariableComponent((Expression)node.getVariable()));
        if (!(this.tabuVariables.contains(this.getVariableComponent((Expression)node.getVariable())) || (typeValue = DFGNodeTypeGetter.getTypeOfDFGNode(node.getValue())) != DFGNodeType.MultivectorComponent && typeValue != DFGNodeType.Variable)) {
            this.mapOneExpressions.put(this.getVariableComponent((Expression)node.getVariable()), this.getVariableComponent(node.getValue()));
            this.setGraphModified();
            this.nodeRemovals.add((SequentialNode)node);
        }
        super.visit(node);
    }

    private VariableComponent getVariableComponent(Expression expression) {
        DFGNodeType typeValue = DFGNodeTypeGetter.getTypeOfDFGNode(expression);
        if (typeValue == DFGNodeType.MultivectorComponent) {
            MultivectorComponent comp = (MultivectorComponent)expression;
            return new VariableComponent(comp.getName(), comp.getBladeIndex(), expression);
        }
        if (typeValue == DFGNodeType.Variable) {
            Variable comp = (Variable)expression;
            return new VariableComponent(comp.getName(), 0, expression);
        }
        return null;
    }

    public void visit(ColorNode node) {
        node.setR(this.performExpressionReplacements(node.getR()));
        node.setG(this.performExpressionReplacements(node.getG()));
        node.setB(this.performExpressionReplacements(node.getB()));
        node.setAlpha(this.performExpressionReplacements(node.getAlpha()));
        super.visit(node);
    }

    public void visit(ExpressionStatement node) {
        node.setExpression(this.performExpressionReplacements(node.getExpression()));
        super.visit(node);
    }

    public void visit(StoreResultNode node) {
        node.setValue((Variable)this.performExpressionReplacements((Expression)node.getValue()));
        super.visit(node);
    }
}

