/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.LoggingListenerGroup;
import de.gaalop.OptimizationException;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.optimization.OptimizationStrategyWithModifyFlag;
import de.gaalop.tba.cfgImport.optimization.gcse.ComparisonResult;
import de.gaalop.tba.cfgImport.optimization.gcse.HashExpression;
import de.gaalop.tba.cfgImport.optimization.gcse.HashExpressions;
import de.gaalop.tba.cfgImport.optimization.gcse.Index;
import de.gaalop.tba.cfgImport.optimization.gcse.IndexCreator;
import de.gaalop.tba.cfgImport.optimization.gcse.OccurenceReplacer;
import de.gaalop.tba.cfgImport.optimization.maxima.MaximaInteractor;
import java.io.IOException;
import java.util.LinkedList;

public class OptGCSE
implements OptimizationStrategyWithModifyFlag {
    private final boolean optMaxima;
    private final String maximaCommand;
    private final boolean createVariablesInGCSE;
    private MaximaInteractor interactor;

    public OptGCSE(boolean optMaxima, String maximaCommand, boolean createVariablesInGCSE) {
        this.optMaxima = optMaxima;
        this.maximaCommand = maximaCommand;
        this.createVariablesInGCSE = createVariablesInGCSE;
    }

    private LinkedList<HashExpressions> findGlobalEqualityGroups(Index index) throws IOException {
        LinkedList<HashExpressions> globalEqualityGroups = new LinkedList<HashExpressions>();
        for (String pattern : index.keySet()) {
            LinkedList<LinkedList> equalityGroups = new LinkedList<LinkedList>();
            for (HashExpression hashExpression : (HashExpressions)index.get(pattern)) {
                LinkedList equalGroup = null;
                for (HashExpressions hashExpressions : equalityGroups) {
                    ComparisonResult comparisonResult = this.compareExpressions(hashExpression.expression, ((HashExpression)hashExpressions.getFirst()).expression);
                    if (comparisonResult == ComparisonResult.EQUAL) {
                        equalGroup = hashExpressions;
                        break;
                    }
                    if (comparisonResult != ComparisonResult.NEGATED) continue;
                    equalGroup = hashExpressions;
                    hashExpression.isNegated = true;
                    break;
                }
                if (equalGroup == null) {
                    equalGroup = new HashExpressions();
                    equalityGroups.add(equalGroup);
                }
                equalGroup.add(hashExpression);
            }
            for (HashExpressions hashExpressions : equalityGroups) {
                if (hashExpressions.size() <= 1) continue;
                globalEqualityGroups.add(hashExpressions);
            }
        }
        return globalEqualityGroups;
    }

    @Override
    public boolean transform(ControlFlowGraph graph, UseAlgebra usedAlgebra, LoggingListenerGroup listeners) throws OptimizationException {
        Index index = IndexCreator.createIndex(graph);
        index.removeEntriesWithSizeOne();
        if (this.optMaxima) {
            this.interactor = new MaximaInteractor(this.maximaCommand);
            this.interactor.openConnection();
        }
        try {
            LinkedList<HashExpressions> globalEqualityGroups = this.findGlobalEqualityGroups(index);
            int counter = 1;
            for (HashExpressions hashExpressions : globalEqualityGroups) {
                Variable gcseTempVar;
                HashExpression firstOccurence = (HashExpression)hashExpressions.getFirst();
                if (firstOccurence.tempVariable != null) {
                    gcseTempVar = firstOccurence.tempVariable;
                } else {
                    gcseTempVar = this.createVariablesInGCSE ? new Variable("temp_gcse_" + counter) : new MultivectorComponent("temp_gcse_" + counter, 0);
                    ++counter;
                }
                AssignmentNode node = new AssignmentNode(graph, gcseTempVar, firstOccurence.expression);
                firstOccurence.node.insertBefore((SequentialNode)node);
                for (HashExpression occurence : hashExpressions) {
                    AssignmentNode occNode;
                    Negation replacement = occurence.isNegated ? new Negation((Expression)gcseTempVar.copy()) : gcseTempVar.copy();
                    OccurenceReplacer.replaceOccurences(occurence.expression, (Expression)replacement, occurence.node);
                    if (!(occurence.node instanceof AssignmentNode) || !(occNode = (AssignmentNode)occurence.node).getVariable().equals((Object)occNode.getValue())) continue;
                    graph.removeNode((SequentialNode)occNode);
                }
            }
        }
        catch (IOException ex) {
            throw new OptimizationException("IOException thrown: " + ex.getMessage(), graph);
        }
        if (this.optMaxima) {
            this.interactor.closeConnection();
        }
        return false;
    }

    private ComparisonResult compareExpressions(Expression expression1, Expression expression2) throws IOException {
        if (expression1.equals(expression2)) {
            return ComparisonResult.EQUAL;
        }
        if (this.optMaxima) {
            if (this.interactor.detectZeroExpression((Expression)new Subtraction(expression1, expression2))) {
                return ComparisonResult.EQUAL;
            }
            if (this.interactor.detectZeroExpression((Expression)new Addition(expression1, expression2))) {
                return ComparisonResult.NEGATED;
            }
            return ComparisonResult.DIFFERENT;
        }
        return ComparisonResult.DIFFERENT;
    }
}

