/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.tba.cfgImport.optimization;

import de.gaalop.LoggingListenerGroup;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.tba.UseAlgebra;
import de.gaalop.tba.cfgImport.optimization.CFGVisitorUsedVariables;
import de.gaalop.tba.cfgImport.optimization.NodeCollectorControlFlowVisitor;
import de.gaalop.tba.cfgImport.optimization.OptimizationStrategyWithModifyFlag;
import de.gaalop.tba.cfgImport.optimization.UpdateLocalVariableSet;
import de.gaalop.tba.cfgImport.optimization.ZeroAssignmentsCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class OptUnusedAssignmentsRemoval
implements OptimizationStrategyWithModifyFlag {
    @Override
    public boolean transform(ControlFlowGraph graph, UseAlgebra usedAlgebra, LoggingListenerGroup listeners) {
        NodeCollectorControlFlowVisitor v = new NodeCollectorControlFlowVisitor();
        graph.accept((ControlFlowVisitor)v);
        LinkedList<Node> nodeList = v.getNodeList();
        HashMap<String, LinkedList<Integer>> outputBlades = new HashMap<String, LinkedList<Integer>>();
        for (String output : graph.getPragmaOutputVariables()) {
            LinkedList<Object> list;
            String[] parts = output.split("\\$");
            if (outputBlades.containsKey(parts[0])) {
                list = outputBlades.get(parts[0]);
            } else {
                list = new LinkedList();
                outputBlades.put(parts[0], list);
            }
            list.add(Integer.parseInt(parts[1]));
        }
        Iterator<Node> descendingIterator = nodeList.descendingIterator();
        CFGVisitorUsedVariables cfgVariableVisitor = new CFGVisitorUsedVariables(outputBlades, usedAlgebra);
        while (descendingIterator.hasNext()) {
            Node cur = descendingIterator.next();
            cur.accept((ControlFlowVisitor)cfgVariableVisitor);
        }
        for (SequentialNode node : cfgVariableVisitor.getNodeRemovals()) {
            graph.removeNode(node);
        }
        boolean changedGraph = !cfgVariableVisitor.getNodeRemovals().isEmpty();
        ZeroAssignmentsCollector collector = new ZeroAssignmentsCollector();
        graph.accept((ControlFlowVisitor)collector);
        for (SequentialNode node : collector.getToRemove()) {
            graph.removeNode(node);
        }
        UpdateLocalVariableSet.updateVariableSets(graph);
        return changedGraph;
    }
}

